/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.netobjects;


import java.util.Date;


/**
 * a <code>Server</code> represents a ServerCache-set from the database
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann
 */

public class Server extends TableRecord {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";

    protected static DBTableAdapter dbTable;

    // Create database definition...
    static {
        dbTable = new DBTableAdapter("ServerTable"); 
		
        /*

         dbTable.addField("host", 			dbTable.STRING,"",  dbTable.KEY);
         dbTable.addField("title", 			dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("description", 	dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("delay", 			dbTable.NUMBER,"0", dbTable.FIELD);
         dbTable.addField("accessStatus", dbTable.STRING,"",  dbTable.FIELD);
         dbTable.addField("firstAccess", 	dbTable.NUMBER,"0", dbTable.FIELD);
         dbTable.addField("lastAccess", 	dbTable.NUMBER,"0", dbTable.FIELD);
         dbTable.addField("accessCounter",dbTable.NUMBER,"0", dbTable.FIELD);
         */
    }

    public String getTitle() {
        return fieldValues.get("title");
    }

    public void setTitle(String v) {
        fieldValues.put("title", v);
		 
    }
	
    public String getDescription() {
        return fieldValues.get("description");
    }

    public void setDescription(String v) {
        fieldValues.put("description", v);
		 
    }

    public String getDelay() {
        return fieldValues.get("delay");
    }

    public void setDelay(String v) {
        fieldValues.put("delay", v);
		 
    }	
	
    /**
     * sets <code>lastAccess</code> to now and increments <code>accessCounter</code><br>
     * if the node is visted for the first time, the method sets <code>firstAccess</code>
     */
    public void access() {
        // is the node accessed for the first time?
        if (getAccessCounter() == 0) {
            fieldValues.put("firstAccess", String.valueOf((new Date()).getTime()));
        }

        setLastAccess((new Date()).getTime());
        incAccessCounter();
        // System.out.println("Access!!!");
    }

    public String getHost() {
        return fieldValues.get("host");
    }
	
    public Server(String host) {
        dbTable.init(this);
        fieldValues.put("host", host);
        dbTable.dbInit(this);
    }

    /**
     * Returns the status of the node, for example <code>200</code> or <code>404</code><br>
     * if <code>-1</code> is returned, the node has not yet been visited
     * @return the status, or <code>-1</code> if no status is available
     */
    public String getAccessStatus() {
        return fieldValues.get("accessStatus");
    }

    /**
     * Sets the status of the node, if the status has been -1 and is now changed, <code>firstAccess</code> is set
     * @param v the status
     */
    public void setAccessStatus(String v) {
        // is the node accessed for the first time?
        if (fieldValues.get("accessStatus").equals("-1")
                && !v.equals("-1")) {}
        fieldValues.put("accessStatus", v);
    }

    /**
     * Returns the date of the first access of this node.<br>
     * Be sure that this node has been accessed before this date is used!
     * @return the date of the first access
     */
    public long getFirstAccess() {
        return Long.parseLong(fieldValues.get("firstAccess"));
    }

    /**
     * Returns the date of the last access of this node.<br>
     * Be sure that this node has been accessed before this date is used!
     * @return the date of the last access
     */
    public long getLastAccess() {
        return Long.parseLong(fieldValues.get("lastAccess"));
    }

    /**
     * Sets the date of the last access (the current access!) of the node.<br>
     * <b>Use <code>access()</code> instead for consistency!</b>
     * @param v the date
     */
    protected void setLastAccess(long v) {
        fieldValues.put("lastAccess", String.valueOf(v));
    }

    /**
     * Returns the times the node has been accessed by any scone-user
     * @return the times the node has been accessed
     */
    public int getAccessCounter() {
        return Integer.parseInt(fieldValues.get("accessCounter"));
    }

    /**
     * Sets the accesCounter to the specified value.<br>
     * <b>Use <code>incAccessCounter()</code> instead for consistency!</b>
     * @param v the date
     */
    protected void setAccessCounter(int v) {
        fieldValues.put("accessCounter", String.valueOf(v));
    }

    /**
     * Increases the accessCounter.<br>
     * <b>Use <code>access()</code> instead for consistency!</b>
     */
    protected void incAccessCounter() {
        try {
            setAccessCounter(getAccessCounter() + 1);
        } catch (Exception e) { // could not convert value in accessCounter to a number!
            setAccessCounter(1); // accessed at least once!
        }
    }

    public void store() {
        dbTable.updateDB(this);
    }	
	
    public Object getKey(int KeyNo) {
        return getHost();
    }
	
}
