/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.netobjects;




/**
 * Defines which methods an object must implement to be handled by a cache
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann
 */

public abstract class TableRecord implements Cacheable {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
   
    /**
     * The set is stored in the cacheTable in this object
     */
    protected CacheTableEntryInterface ctei;
  
    /**
     * The values of the set
     */
    protected FieldValueHashTable fieldValues;

    /**
     * Indicates whether the set has changed compared to the database
     */
    protected boolean hasChanged;

    /**
     * True, if this object corresponds to a db-set
     */
    public boolean hasRecordInDB = false;	

    /**
     * Indicates whether the set shall be store in the database
     */
    protected boolean persistent = true; // default is true
   
    // Helper variable
    protected static java.util.Date date = new java.util.Date();
	
    public void setCacheTableEntryInterface(CacheTableEntryInterface ctei) {
        this.ctei = ctei;
    }	

    /**
     * Tell an object, that is has changed...
     */
    protected void setChanged(boolean changed) {
        if (changed == true) {
            if (!hasChanged) {
                if (ctei != null) {
                    ctei.hold();
                }
                hasChanged = true;				
            }
        } else {
            hasChanged = false;
        }
    }

    /**
     * Tell an object, that is shall not be made persistent.
     * @param p shall object be made persistent in DB?
     */
    protected void setPersistent(boolean p) {
        persistent = p;
    }

    /**
     * Ask object if it will be made persistent.
     */
    protected boolean isPersistent() {
        return persistent;
    }

    /**
     * @param the key number
     * @return the Key(s) corresponding to the object. 
     */
    public abstract Object getKey(int noOfKey);
	
    /**
     * Returns the current time as a string
     */
    public String now() {
        return String.valueOf(date.getTime());
    }
				
}
