/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.proxy;

import com.ibm.wbi.*;
import com.ibm.wbi.protocol.http.*;
import java.io.IOException;

public class FixContentTypeEditor2 extends HttpEditor
{

    public static final String COPYRIGHT = "(C) Harald Weinreich";
	
	public FixContentTypeEditor2()
    {
    }

    public void handleRequest(RequestEvent requestevent) throws RequestRejectedException, IOException
    {
        DocumentInfo documentinfo = (DocumentInfo)requestevent.getRequestInfo();
        if(documentinfo.getResponseCode() == 200)
        {
        	String s = documentinfo.getResponseContentType();
            byte start[] = new byte[16];
            requestevent.getMegInputStream().peek(start);
            // test for html
            for (int i=0;i<15;i++) {
            	if(start[i] == '<') // an < so it is probably html 
                    throw new RequestRejectedException();
            }
            // test for JavaScript
            for (int i=0;i<12;i++) {
            	if ( (start[i] == 'v' && start[i+1] == 'a' && start[i+2] == 'r') || 
   				     (start[i] == 'V' && start[i+1] == 'A' && start[i+2] == 'R') ||
				     (start[i] == '/' && start[i+1] == '*' ) ||
				     (start[i] == '/' && start[i+1] == '/' ) ||
				     (start[i] == 'f' && start[i+1] == 'u' && start[i+2] == 'n' && start[i+3] == 'c')
					) // it is probably JavaScript... 
            	{
            		HttpResponse httpresponse = new HttpResponse(requestevent, false);
            		httpresponse.setContentType("application/x-javascript");
            		httpresponse.writeHeader(requestevent);
            		requestevent.getMegOutputStream().write(requestevent.getMegInputStream());
            		requestevent.getMegOutputStream().close();
            		return;
            	}   
            }
            // test for CSS
            for (int i=0;i<15;i++) {
            	if ( (start[i] == '{' )
					) // it is probably an CSS... 
            	{
            		HttpResponse httpresponse = new HttpResponse(requestevent, false);
            		httpresponse.setContentType("text/css");
            		httpresponse.writeHeader(requestevent);
            		requestevent.getMegOutputStream().write(requestevent.getMegInputStream());
            		requestevent.getMegOutputStream().close();
            		return;
            	}   
            }
            throw new RequestRejectedException();
        } else
        {
            throw new RequestRejectedException();
        }
    }

}