/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.proxy;


import java.util.Enumeration;
import java.util.Hashtable;

import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.protocol.http.DocumentInfo;
import com.ibm.wbi.protocol.http.HttpGenerator;
import com.ibm.wbi.protocol.http.beans.FileGenerator;


/**
 * This meg is able to return documents to the browser.
 * <br>It maps web - paths to filesystem - paths.
 * Use <code>addPath()</code> to add a new mapping
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann
 */

public class GeneralResourceGenerator extends HttpGenerator {

    // the mappings
    protected static Hashtable paths = new Hashtable();

    public void handleRequest(RequestEvent e) throws RequestRejectedException {

        DocumentInfo documentInfo = (DocumentInfo) e.getRequestInfo();
        String url = documentInfo.getUrl();
        String urlL = url.toLowerCase();
        String path = documentInfo.getPath() + documentInfo.getQuery();
        String pathL = path.toLowerCase();
        String prefix = "";
        String key = "";

        for (Enumeration en = paths.keys(); en.hasMoreElements();) {
            key = (String) en.nextElement();
            if (urlL.startsWith(key)) {
                prefix = url;
                break;
            }  // If url or path starts with the key, then reply to request...
            if (pathL.startsWith(key)) {
                prefix = path;
                break;
            }
            key = "";
        }

        if (!key.equals("")) {
            String localPath = (String) paths.get(key);

            localPath += prefix.substring(key.length());
            String contentType = getContentType(prefix.substring(prefix.lastIndexOf(".") + 1));
            FileGenerator rg = new FileGenerator(localPath, contentType);

            try {
                forwardRequest(rg, e);
            } catch (java.io.IOException ex) {
                System.out.println("GeneralResourceGenerator: problems sending file " + prefix);
            }
            
        } else {
            throw new RequestRejectedException();
        }
    }

    /**
     * adds a new mapping to the </code>GeneralResourceGenerator<code> class.<br>
     * @param web the web path e.g. "http://_scone/"
     * @param fielSystem the local path e.g. "c:\anywhere\"
     */
    public static void addPath(String web, String fileSystem) {
        paths.put(web.toLowerCase(), fileSystem);
    }

    // tries to find out the content type of a document by examinig the filename-extension
    protected String getContentType(String ext) {
        ext = ext.toLowerCase();
        if (ext.equals("css")) {
            return "text/css";
        }
        if (ext.equals("js")) {
            return "application/x-javascript";
        }
        if (ext.equals("gif")) {
            return "image/gif";
        }
        if (ext.equals("jpg")) {
            return "image/jpeg";
        }
        if (ext.equals("jpeg")) {
            return "image/jpeg";
        }
        if (ext.equals("class")) {
            return "application/java-vm";
        }
        if (ext.equals("jar")) {
            return "application/java-vm";
        }
        return "text/html";
    }
}
