/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.proxy;


import java.io.IOException;
import java.net.URL;

import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.protocol.http.DocumentInfo;
import com.ibm.wbi.protocol.http.HttpRequest;
import com.ibm.wbi.protocol.http.HttpRequestEditor;


/**
 * This meg is able to return documents to the browser. 
 * <br>It maps web - paths to filesystem - paths.
 * Use <code>addPath()</code> to add a new mapping
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann
 */

public class NewServerRequestEditor extends HttpRequestEditor {
    public static final String COPYRIGHT = " (C) Copyright IBM Corp. 1999. All Rights Reserved. ";
    private String newServer;
    private int newPort;

    public NewServerRequestEditor() {
        newServer = null;
        newPort = 0; // Do not change URL
    }

    public String getNewServer() {
        return newServer;
    }

    public int getNewPort() {
        return newPort;
    }

    public void handleRequest(RequestEvent requestevent) 
            throws RequestRejectedException, IOException {
        if (newServer == null || newServer.length() == 0) {
            throw new RequestRejectedException();
        } else {
            DocumentInfo documentinfo = (DocumentInfo) requestevent.getRequestInfo();
            HttpRequest httprequest = new HttpRequest(requestevent, false);
            // HttpRequest httprequest = HttpRequestEditor.getOriginalHttpRequest(requestevent);
            
            // Get request URL
            String requestUrl = httprequest.getUrl();

            // System.out.println(requestUrl);

            // Server was missing: look for Server in Host: parameter
            if (!requestUrl.startsWith("http://")
                    && httprequest.get("Host") != null) {
                requestUrl = "http://" + httprequest.get("Host") + requestUrl;
            }
            // System.out.println(requestUrl);

            // Try to change the request URL
            try {
                URL url1 = new URL(requestUrl);
                URL url2 = null;

                if (newPort == 0) {  // Do not change port...
                    url2 = new URL(url1.getProtocol(), newServer, url1.getPort(), url1.getFile() + (url1.getRef() != null ? "#" + url1.getRef() : ""));
                } else {  // Change Server and Port
                    url2 = new URL(url1.getProtocol(), newServer, newPort, url1.getFile() + (url1.getRef() != null ? "#" + url1.getRef() : ""));
                }
                // new Url...
                requestUrl = url2.toString();
                // Set Request to new Url
                httprequest.setUrl(requestUrl);
                // System.out.println(requestUrl);
            } catch (Exception exception) { // System.err.println("Error"); 
            }
            // httprequest.setServer(newServer);  // Doesn't work well
            documentinfo.setRequestHeader(httprequest.produceRequestWithoutContent()); // change request...
            requestevent.getMegOutputStream().write(requestevent.getMegInputStream()); // write new request...

            // HttpRequestEditor.setFinalHttpRequest(requestevent, httprequest);
            return;
        }
    }

    public void setNewServer(String s) {
        newServer = s;
    }

    public void setNewPort(int p) {
        newPort = p;
    }
}
