/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.proxy;

import java.io.IOException;

import scone.util.ErrorLog;

import com.ibm.wbi.Editor;
import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.protocol.http.DocumentInfo;
import com.ibm.wbi.protocol.http.HttpEditor;
import com.ibm.wbi.protocol.http.HttpResponseHeader;


/**
 * The NoCacheMeg is a WBI MEG that adds "NoCache" command in the header of the response of a server. Use it
 * if your plugin requires to reload the page even if the back-button is pressed...
 * <br>
 *
 * It is activated if you set the plugin.NOCACHE requirement
 *
 */

public class NoCacheMeg extends Editor {
    public static final String COPYRIGHT = "(C) Harald Weinreich";

    /**
     * the MEG's handleRequest() method.
     */
    public void handleRequest(RequestEvent e) throws RequestRejectedException, IOException {

        try {
            DocumentInfo documentInfo = (DocumentInfo) e.getRequestInfo(); // get RequestInfo
            HttpResponseHeader response = documentInfo.getHttpResponseHeader();  // get the response header
            // Remove old headers...
            response.remove("Pragma");
            response.remove("Cache-Control");
            response.remove("Expires");
            // Disable Caching
            response.add("Pragma", "no-cache");         // HTTP 1.0 (Most browsers)
            response.add("Cache-Control", "no-cache");  // HTTP 1.1: IE 5&6
            response.add("Cache-Control", "no-store, must-revalidate, private");  // HTTP 1.1: IE 5&6
            response.add("Cache-Control", "post-check=0, pre-check=0");
            response.add("Cache-Control", "max-age=0");
            response.add("Expires", "Tue, 13 Dec 1988 09:00:00 GMT");   // Page is expired...
            // response.add("Last-Modified", "Mon, 14 Jun 2004 09:00:00 GMT");  
            // header('Last-Modified: ' . gmdate("D, d M Y H:i:s") . " GMT");   // always changed...
        } catch (Exception exc) {
            ErrorLog.log(this, "handleRequest()", "", exc);
        }
        throw new RequestRejectedException();
    }
}
