/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.proxy;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Date;

import scone.util.ErrorLog;

import com.ibm.wbi.Editor;
import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.protocol.http.DocumentInfo;
import com.ibm.wbi.protocol.http.HttpEditor;
import com.ibm.wbi.protocol.http.HttpResponseHeader;


/**
 * The PageTimeoutMeg is a WBI MEG that adds timeout commands to the header of the server response. 
 * It is similar to the NoCacheMeg but the user does not have to reload pages every time as
 * the timeout is set to 5min.
 * USe it, if your plugin requires to reload the page every time a user starts the browser...
 * <br>
 *
 * It is activated if you set the plugin.PAGETIMEOUT requirement
 *
 */

public class PageTimeoutMeg extends Editor {
    public static final String COPYRIGHT = "(C) Harald Weinreich";

    /**
     * the MEG's handleRequest() method.
     */
    public void handleRequest(RequestEvent e) throws RequestRejectedException, IOException {

        try {
            DocumentInfo documentInfo = (DocumentInfo) e.getRequestInfo(); // get RequestInfo
            HttpResponseHeader response = documentInfo.getHttpResponseHeader();  // get the response header
            // Remove old headers...
            //response.remove("Pragma");
            //response.remove("Cache-Control");
            response.remove("Last-Modified");
            response.remove("Expires");
            response.remove("Date");
            // Disable Caching
            //response.add("Pragma", "no-cache");         // HTTP 1.0 (Most browsers)
            // response.add("Cache-Control", "no-cache");  // HTTP 1.1: IE 5&6
            // response.add("Cache-Control", "no-store, private");  // HTTP 1.1: IE 5&6
            //response.add("Cache-Control", "no-store, must-revalidate, private");  // HTTP 1.1: IE 5&6
            // response.add("Cache-Control", "post-check=0, pre-check=0");
            //response.add("Cache-Control", "max-age=300");  // 5 min.
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US); // 09-Nov-2030 23:59:00 GMT;
            String dateModified = formatter.format(new Date())+" GMT"; 
            String dateExpires  = formatter.format(new Date(new Date().getTime()+3000))+" GMT";   // 3 sec...
            // System.out.println(dateString);
            response.add("Date", dateModified);   // Page is up-to-date
            response.add("Last-Modified", dateModified);   // Page is up-to-date
            response.add("Expires", dateExpires);   // Page is expired...
            // response.add("Expires", "Tue, 13 Dec 1988 09:00:00 GMT");   // Page is expired...
            // response.add("Last-Modified", "Mon, 14 Jun 2004 09:00:00 GMT");  
            // header('Last-Modified: ' . gmdate("D, d M Y H:i:s") . " GMT");   // always changed...
            
        } catch (Exception exc) {
            ErrorLog.log(this, "handleRequest()", "", exc);
        }
        throw new RequestRejectedException();
    }
}
