/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.proxy;

import scone.util.DocumentParser;
import scone.util.tokenstream.SconePipe;

import com.ibm.wbi.RequestEvent;


/**
 * transforms tokens into database objects.<p>
 * This Editor is initialized and set up by the Scone framework. Do not use it!
 * <br>
 * The <code>ParsingMeg</code> should be registered as the first monitor.
 * It is registered at <code>Scone</code> by default.<p>
 * Tokens are transformed using scone.util.DocumentParser<p>
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann
 */
public class ParsingMeg extends HtmlTokenEditor {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
	
    private DocumentParser parser = null;

    /**
     * create the initial instance
     */
    public ParsingMeg(int requirements) {
        parser = new DocumentParser(requirements);
    }

    /**
     * Parse document and collect data for NetNode and HtmlNode objects: number of links,
     * number of images, language etc.
     */

    public void handleRequest(SconePipe pipe) {
        // Trying to get the POST parameters set by the "PostDataExtractor"
        RequestEvent e=pipe.getRequestEvent();
        // DocumentInfo documentInfo = (DocumentInfo) e.getRequestInfo();

        if (e.getMegContext().getMegResource("post-data")!=null) {
            //System.out.println("Post-data (responseEditor): "+e.getMegContext().getMegResource("post-data"));

            /* // Test all header parameters
            // System.out.println("Post-data: "+documentInfo.getTransactionData("post-data")); // DOESN'T WORK!! because of a bug in WBI!
            for (Enumeration enu = documentInfo.getAllKeys(DocumentInfo.REQUEST_HEADER) ; enu.hasMoreElements() ;) {
                String key=(String)enu.nextElement();
                System.out.print(key+": ");
                System.out.println(documentInfo.getByKey(key,DocumentInfo.REQUEST_HEADER));
            }
            System.out.println(); */
            pipe.getTokenInputStream().getMetaInfo().put("postData", e.getMegContext().getMegResource("post-data"));
        }
        // Now parse the response...
        parser.parse(pipe.getTokenInputStream(), pipe.getTokenOutputStream());
    }

}

