/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.proxy;


import com.ibm.wbi.ResponseToRequest;
import com.ibm.wbi.protocol.http.beans.link.LinkRewriter;


/**
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann
 */

public class ServerScoutLinkRewriter implements LinkRewriter {
    private String base = null;
    private String protocol = null;
    private String server = null;
    private String path = null;
   
    // Standard Constructor
    public ServerScoutLinkRewriter() {
        initBase("http://localhost:8088/");
    }

    // Constructor
    public ServerScoutLinkRewriter(String base) {
        initBase(base);
    }
   
    // set the base URL of the page
    private void initBase(String baseString) {
        // System.out.println(baseString);
        int protocolLen = 7;

        if (baseString.startsWith("http://")) { 
            protocolLen = 7;
        } else if (baseString.startsWith("https://")) {  // I think, this never happens...
            protocolLen = 7;
        } else { 
            return;
        }  // Error!!!
        base = baseString.substring(0, baseString.lastIndexOf("/")) + "/";   // Create base url (until last /)
        // System.out.println(base);
        protocol = baseString.substring(0, protocolLen);
        // System.out.println (protocol);
        String serverPath = base.substring(protocolLen);      // get Server and Path without protocol...
        int i = serverPath.indexOf("/");

        server = serverPath.substring(0, i);
        // System.out.println (server);
        if (i == -1) {
            path = "";
        } else { 
            path = serverPath.substring(i);
        }
        // System.out.println (path);
    }

    public void setBase(String base) {
        initBase(base);
    }

    public void setServer(String server) {
        this.server = server;
        base = protocol + server + path;
    }

    public String getBase(ResponseToRequest responsetorequest) {
        return base;
    }
   
    // Init with String or URL or what ever...
    public void initialize(Object server) // Object obj) 
    { 
        this.server = (String) server;  
    }
   
    // Modifies a link URL (href=)
    public String rewriteLink(ResponseToRequest responsetorequest, String link) {
        if (link == null) {
            return null;
        }

        if (link.startsWith("http://")) {
            String protocol = "http://";
            String rest = link.substring(7);

            System.out.println(rest);
            int serverlen = rest.indexOf("/");
            String server = rest.substring(0, serverlen);

            rest = link.substring(serverlen);
            if (server.equals("localhost") || server.equals("localhost:80")) {
                link = this.protocol + this.server + rest;
            }
        }

        /* int i = link.indexOf(":");    // Is there a colon?
         int j = link.indexOf("/");    // Where is the first slash?
         if(i == -1 || j != -1 && i >= j)  // No protocol OR no (server and path) OR Colon after Slash !?! (Query?)
         if(link.startsWith("/"))       // absolute URL?
         link = protocol + server + link;
         else
         link = base + link;  // base = protocol + server + path
         */
        return link; 
    }

    // Modifies a source URL (src=)
    public String rewriteSource(ResponseToRequest responsetorequest, String source) {
        return rewriteLink(responsetorequest, source);
    }

}

