/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.ras;


/*
 A dedicated ConnectionHandler provides a new instance 
 for each client. It is stateful, i.e. calling sleep() 
 and wake() on the client's connection is not associated 
 with returning from and calling the handle() method.
 */   
public class DedicatedHandlerExample implements ConnectionHandler {
    public void handle(Connection connection) {
        int sum = 0;

        System.out.println("starting DedicatedHandlerExample");
        // a dedicated handler may have an endless loop,
        // a singleton handler may not!
        while (true) {
            try {
                String value = connection.read();

                // the connection is closed if read() returns null!
                if (value == null) {
                    System.out.println("stopping DedicatedHandlerExample");
                    return;
                }
                System.out.println("DedicatedHandler: adding " + value);
                sum += Integer.parseInt(value);
                connection.write("sum: " + sum);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
