/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.ras;


public class RasTest {

    public static void main(String[] args) {
        new RasTest();
    }
   
    public RasTest() {
        try {
            RasServer server = new RasServer(1234);

            server.start();
            (new SingletonClient()).test();
            (new DedicatedClient()).test();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
   
    class SingletonClient {
   
        public synchronized void test() throws Exception {
            Connection con = new Connection("localhost", 1234, "scone.ras.SingletonHandlerExample");

            super.wait(1000);
            System.out.println("SingletonClient: sending hello");
            con.write("hello");
            super.wait(1000);
            System.out.println("SingletonClient: receiving " + con.read());
         
            // the protocol has been worked through, we can now
            // cut the underlying tcp/ip connection to free ressources
            con.sleep();
         
            // revive the underlying tcp/ip connection
            // we can now go through the protocol again, 
            // no states have been remembered!
            con.wake();
         
            super.wait(1000);
            System.out.println("SingletonClient: sending how are you?");
            con.write("how are you?");
            super.wait(1000);
            System.out.println("SingletonClient: receiving " + con.read());
            super.wait(1000);
            con.close();
            super.wait(1000);
        }
      
    }


    class DedicatedClient {
   
        public synchronized void test() throws Exception {
      
            // the "true" parameter tells the connection that it will
            // talk to a dedicated instance
            Connection con = new Connection("localhost", 1234, "scone.ras.DedicatedHandlerExample", true);

            super.wait(1000);
            System.out.println("DedicatedClient: sending 2");
            con.write("2");
            super.wait(1000);
            System.out.println("DedicatedClient: receiving " + con.read());
         
            // with a dedicated handler, we can cut the underlying 
            // tcp/ip connection at any time.
            // (not quite right. we can only cut the connection when the
            // serverside handler tries to read from the connection!)
            con.sleep();
         
            // we can now revive the tcp/ip connection and continue
            // where we had stopped.
            con.wake();
         
            super.wait(1000);
            System.out.println("DedicatedClient: sending 3");
            con.write("3");
            super.wait(1000);
            System.out.println("DedicatedClient: receiving " + con.read());
            con.close();
        }
      
    }   

}
