/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.ras;   
   

/*
 A singleton ConnectionHandler is a stateless handler.
 There exists just one instance of it and every client
 connects to this instance. 
 The handle() method describes the protocol the client 
 and the handler use. This method is called each time
 a connection is established or woken. When it returns,
 the connection is automatically closed. The client 
 should only call its connection's sleep() method when
 the handle() method has returned.
 */
public class SingletonHandlerExample implements ConnectionHandler {

    public void handle(Connection connection) {
        System.out.println("starting SingletonHandlerExample");      
        try {
            String message = connection.read();

            System.out.println("SingletonHandler: echoing " + message);
            connection.write(message);
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("stopping SingletonHandlerExample");      
    }
   
}
