/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.robot;


import java.util.Enumeration;


/**
 * This class is used to determine whether a page with the same content has been loaded during the processing of the task.
 *
 * @author Frank Wollenweber
 */


class ContentSeenFilter implements PageFilter {

    /**
     * The constructor
     */
    ContentSeenFilter() {}

    /**
     * Determines whether a page with the same content has been loaded during the processing of the task.
     * @param robotHtmlNode Check if the content of the HtmlNode belonging to robotHtmlNode has been seen.
     * @param qe The entry of the queue which causes the robot to download robotHtmlNode. The QueueEntry belongs to a robotTask.
     * @return true, if the robot has not found any other document with the same content during the processing of the task.
     */
    public boolean filter(RobotHtmlNode robotHtmlNode, QueueEntry qe) {
        Enumeration resultNodes = qe.getRobotTask().getResultNodes();

        while (resultNodes.hasMoreElements()) {
            RobotHtmlNode rnode = (RobotHtmlNode) resultNodes.nextElement();

            if (rnode.getSimpleUri().equals(robotHtmlNode.getSimpleUri())) {
                return true;
            }
            try {
                if (rnode.getHtmlNode().getFingerprint().equals(robotHtmlNode.getHtmlNode().getFingerprint())) {
                    return false;
                }
            } catch (NoHtmlNodeException e) {}
        }
        return true;
    }
}
