/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.robot;


/**
 * Implementation of a lifo queue used for depthsearch
 *
 * @author Frank Wollenweber
 */



public class DepthSearchURLQueue extends BreadthSearchURLQueue {

    /**
     * The constructor
     */
    public DepthSearchURLQueue() {
        super();
    }

    /**
     * Get the next entry from the queue
     * @return The next entry
     */
    public QueueEntry dequeue() {
        QueueEntry qe = (QueueEntry) queue.lastElement();

        queue.remove(queue.size() - 1);
        numberOfElements--;
        return qe;
    }
}
