/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.robot;


/**
 * This interface defines the functionaltity of a link classifier.
 *
 * @author Frank Wollenweber
 */



public interface LinkClassifier {

    /**
     * When a page is loaded the classify method is called for each link of the page.
     * Classify gets a robotLink and can use the setAttribute method to attach attributes to the robotLink
     * @param robotLink The link to classify
     * @param robotHtmlNode The document where the link was found
     * @param qe The entry of the queue which causes the robot to download robotHtmlNode. This parameter gives the classifier access to the RobotTask and the current scanning-depth.
     */
    public void classify(RobotLink robotLink, RobotHtmlNode robotHtmlNode, QueueEntry qe);
}
