/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.robot;


/**
 * This interface defines the functionaltity of a page filter.
 *
 * @author Frank Wollenweber
 */



public interface PageFilter {
    
    /**
     * When a page is loaded the filter method is called for the page.
     * Filter gets a robotHtmlNode and can use the getAttribute method to get the attributes attached to the robotHtmlNode.
     * This method decides, if the crawling should be continued or not. The values of all filters are combined with the and operator
     * @param robotHtmlNode to filter
     * @param qe The entry of the queue which causes the robot to download robotHtmlNode. This parameter gives the filter access to the RobotTask and the current scanning-depth.
     * @return True, if the crawling should be continued.
     */


    public boolean filter(RobotHtmlNode robotHtmlNode, QueueEntry qe);
}
