/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.robot;


import java.util.TimerTask;


/**
 * This TimerTask is used to limit the time for the download of a document
 *
 * @author Frank Wollenweber
 */


class PageLoaderInterruptTimer extends TimerTask {
    
    private PageLoaderThread plt; // This PageLoaderThread is called to interrupt the download

    /**
     * constructor
     * @param plt Interrupt this pageLoaderThread
     **/
    public PageLoaderInterruptTimer(PageLoaderThread plt) {
        super();
        this.plt = plt;
    }

    /**
     * This method is called by the timer
     **/
    public void run() {
        plt.interrupt();
    }
}
