/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.robot;


/**
 * PageLoaderPoolStaats is part of a threadpool implementation described in the article
 * "Why Thread Pools are Important in Java" by Tarak Modi, Java Pro magazine.
 * http://www.devx.com/upload/free/features/javapro/2000/10oct00/tm0010/tm0010.asp<br><br>
 *
 * This class holds the statistics of the
 * Thread Pool from which it was returned
 */



public class PageLoaderPoolStats {

    /**
     * Maximum number of threads the pool is allowed to create
     **/
    public int maxThreads;

    /**
     * Minimum number of running threads
     **/
    public int minThreads;

    /**
     * The maximum time a threa is allowed to be idle before it is stopped
     **/
    public int maxIdleTime;

    /**
     * Number of threads in the pool
     **/
    public int numThreads;

    /**
     * Jobs in the queue waiting for execution
     **/
    public int pendingJobs;

    /**
     * Jobs currently running
     **/
    public int jobsInProgress;

    /**
     * Formats a string with the statistics
     * @return A String containing the statistics
     **/
    public String toString() {
        java.lang.StringBuffer sb = new java.lang.StringBuffer();
        String strMax = (maxThreads == -1)
                ? "No limit"
                : new Integer(maxThreads).toString();
        String strMin = (minThreads == -1)
                ? "No limit"
                : new Integer(minThreads).toString();

        sb.append("maxThreads = " + strMax + "\n");
        sb.append("minThreads = " + strMin + "\n");
        sb.append("maxIdleTime = " + maxIdleTime + "\n");
        sb.append("numThreads = " + numThreads + "\n");
        sb.append("pendingJobs = " + pendingJobs + "\n");
        sb.append("jobsInProgress = " + jobsInProgress + "\n");
        return (sb.toString());
    }
}
