/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.robot;


import scone.netobjects.SimpleUri;


/**
 * This class represents entries of the urlQueue
 *
 * @author Frank Wollenweber
 */



public class QueueEntry {

    private SimpleUri uri; // download this uri
    private int depth; // crawl the web with this depth
    private RobotTask robotTask; // the robot task this queueEntry belongs to

    /**
     * Constructor
     * @param url download this url
     * @param depth scan this subgraph of the web with this depth
     * @param robotTask the robotTask this queueEntry belongs to
     */
    public QueueEntry(SimpleUri uri, int depth, RobotTask robotTask) {
        this.uri = uri;
        this.depth = depth;
        this.robotTask = robotTask;
    }

    /**
     * Get the url of this queueEntry
     * @return the url
     */
    public SimpleUri getURI() {
        return uri;
    }

    /**
     * Get the depth of the queueEntry
     * @return the subtree of the web should be downloaded with this depth
     */
    public int getDepth() {
        return depth;
    }

    /**
     * Set the depth of the queueEntry
     * @param depth the subtree of the web should be downloaded with this depth
     */
    public void setDepth(int depth) {
        this.depth = depth;
    }

    /**
     * Get the robotTask this queueEntry belongs to
     * @return the robotTask
     */
    public RobotTask getRobotTask() {
        return robotTask;
    }

}
