/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.robot;


import HTTPClient.HTTPConnection;


/**
 * This class extends the HTTPClient.HTTPConnection with functionality to see if the connection has been reused
 *
 * @author Frank Wollenweber
 */


class RobotHttpConnection extends HTTPConnection {

    int uses; // This value is set by the PoolHttpConnection, an inner class in HttpConnectionPool. 0: not used before, 1 used once, 2 used twice or more 

    /**
     * constructor
     * @param host Build up a connection to this host...
     * @param port ... to this port
     */
    RobotHttpConnection(String host, int port) {
        super(host, port);
        uses = 0;
    }

    /**
     * Checks, if the connection has been reused. If the connection is reused, then it is possible that the persistent http-connection has been keept open.
     * @return true, if the connection has been reused
     */
    synchronized boolean reUsed() {
        return (uses > 1);
    }

} 

