/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.robot;


import java.util.Hashtable;

import scone.netobjects.Link;


/**
 * A robotLink is a normal link object with a set of attributes.
 * There can be many robotLinks for one link object
 *
 * @author Frank Wollenweber
 */



public class RobotLink {
    
    private Link link; // Many robotLinks can reference the same link object
    private Hashtable linkAttributes; // LinkClassifier can add attributes to this link

    /**
     * Constructor
     * @param link the link this robotLink belongs to
     */
    public RobotLink(Link link) {
        this.link = link;
        linkAttributes = new Hashtable();
    }

    /**
     * Get the link
     * @return the link
     */
    public Link getLink() {
        return link;
    }

    /**
     * set the link
     * @param link the link
     */
    public void setLink(Link link) {
        this.link = link;
    }

    /**
     * Get the value of the specified attribute
     * @param key This key identifies one attribute
     * @return The value of the attribute
     */
    public String getAttribute(String key) {
        return (String) linkAttributes.get(key);
    }

    /**
     * Set the value of the specified attribute
     * @param key The name of the attribute
     * @param value The value of the attribute
     */
    public void setAttribute(String key, String value) {
        linkAttributes.put(key, value);
    }
    
}
