/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.robot;


import scone.Plugin;
import scone.util.ErrorLog;


/**
 * This Scone-Plugin gives information about the status of the robot.<br>
 * Enable this plugin an access http://_robot.scone.de to see what's the robot doing.
 *
 * @author Frank Wollenweber
 */


public class RobotMonitor extends Plugin {

    /**
     * Get the requirements for this plugin
     */
    public int getRequirements() {
        return NOREQUIREMENTS; // no requirements!
    }

    /**
     * Initializes this plugin
     */
    public void init() {
        try {
            // add the meg
            RobotMonitorMeg robotMonitorMeg = new RobotMonitorMeg();

            robotMonitorMeg.setup("robotMonitorMeg", "host~_robot.scone.de", 3);
            addMeg(robotMonitorMeg);
        } catch (Exception e) {
            ErrorLog.log(this, "init()", "Could not enable RobotMonitor!", e);
        }
    }
    
}
