/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.robot;


/**
 * All classes, which want to use the robot, must implement this interface
 *
 * @author Frank Wollenweber
 */



public interface RobotUser {

    /**
     * This method is called for every processed htmlNode
     * @param robotHtmlNode the new htmlNode with some properties set by the robot
     * @param robotTask identifies the task which causes the robot to download robotHtmlNode. RobotUser can start many task simultaneously.
     */
    abstract void robotNewPage(RobotHtmlNode robotHtmlNode, RobotTask robotTask);

    /**
     * This method is called, if the task was completely finished
     * @param robotTask the robot finished this task
     */
    abstract void robotTaskFinished(RobotTask robotTask);

}
