/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.robot;


import java.util.Vector;

import scone.netobjects.SimpleUri;


/**
 * This interface defines the functionaltity needed for the url queue.
 * Different serving strategies can be defined by writing a class which implements this interface
 *
 * @author Frank Wollenweber
 */



public interface URLQueue {
    
    /*
     void setSizeLimit(int size);
     
     void unsetSizeLimit();
     */


    /**
     * Adds a new entry to the queue
     * @param qe The new entry
     */
    void queue(QueueEntry qe);

    /**
     * Get the next entry from the queue
     * @return The next entry
     */
    QueueEntry dequeue();

    /**
     * Get the number of entries waiting in the queue
     * @return Number of elements
     */
    int size();

    /** Get the number of entries belonging to the robotTask
     * @param robotTask only entries of this task are counted
     * @return Number of entries
     */
    int getNumberOfPendingQueueEntries(RobotTask robotTask);

    /** Get vector with all entries belonging to the robotTask
     * @param robotTask only entries of this task are added to the vector
     * @return Vector with queueEntries
     */
    Vector getPendingQueueEntries(RobotTask robotTask);

    /** Remove all queueEntries belonging to this task
     * @param robotTask only entries of this task are removed
     */
    void removeAllQueueEntries(RobotTask robotTask);

    /** The number of queueEntries from different tasks waiting to download this url
     * @param url Only queueEntries with this url are counted
     * @return Number of entries
     */
    int getNumberOfPendingQueueEntries(SimpleUri uri);

    /** The vector with all queueEntries from different tasks waiting to download this url
     * @param url Only queueEntries with this url are added to the vector
     * @return Vector with queueEntries
     */
    Vector getPendingQueueEntries(SimpleUri uri);

    /** Checks, if there is an entry belonging to robotTask, which is waiting to download url
     * @param url The url to check
     * @param robotTask Only entries of this task are checked
     * @return True, if there is an entry waiting
     */
    boolean isPendingURL(SimpleUri uri, RobotTask robotTask);

    /** Get the entry belonging to robotTask and waiting to download url
     * @param url The url to check
     * @param robotTask Only entries of this task are checked
     * @return The waiting queueEntry
     */
    QueueEntry getPendingURL(SimpleUri uri, RobotTask robotTask);

    /** Remove the an entrie from the queue
     * @param qe The entry to remove
     */
    void removeQueueEntry(QueueEntry qe);

}
