/*
 * Scone - The Web Enhancement Framework
 * Copyright (c) 2004 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.usertesttool;


import java.util.Observable;
import java.util.Observer;

import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.DBTableAdapter;


/**
 * This class receives Access events, determines the event's type and calles
 * a corresponding method in class UserTestControl to pass on the information.
 
 * @author Torsten Hass, Harald Weinreich
 * @version 0.9, 06/05/2003
 */ 
public class EventObserver implements Observer {

    // The utc object that has to be informed about opened web pages
    public static UserTestControl utc; 

    public EventObserver() {
        AccessCache.putObserver(this);
    }


    /** 
     * This method is called every time an Access event is fired.
     * The type of Access event is determined and a corresponding method of 
     * the UserTestControl is called to inform it about this event
     * For further information about Observer events see class 
     * scone.examples.observertest.ObserverTestPlugin
     */
    public void update(Observable o, Object arg) {
        if (o instanceof AccessCache) {
            AccessEvent e = (AccessEvent) arg;

//            System.out.println("EventOberver: Update was called with getAction="+e.getAccess().getAction()+" and staytime="+e.getAccess().getAction());
            if (e.getNode() == null) {
                if (DBTableAdapter.useDb()) {
                   System.out.println("UserTest: Unknown NetNode! Please restart Scone and clear cache of browser!");
                } else {
                   System.out.println("UserTest: Unknown NetNode! Database is deactivated...");
                }
            } else {
                if (e.getAccess().getLoadTime() == 0) {         // first AccessEvent before page ist completely loaded
                    utc.pageLoading(e.getAccess());
                } else if (e.getAccess().getStayTime() != 0) {  // last AccessEvent before page is unloaded
                    utc.pageUnloading(e.getAccess());
                }
            }
        }
    }


    public static void setUtc (UserTestControl AUtc) {
        utc = AUtc;
    }
}
