package scone.usertesttool;


/**
 * Interface for input components like textFields and comboBoxes
 *
 * @author Torsten Hass
 * @version 1.0, 08/27/2003
 */

public interface InputComponent {
//    public void setName(String componentName);
//    public String getName();                                    // Get Name of the component to distinct multiple Components
    public void setInputRequired(boolean inputRequired);
    public boolean changedByUser();                             // for textfields comboboxes etc.: was Text typed in or a selectable item choosed
    public void setComponentHighlighted(boolean highlight);
    // Data read out
    public void startDataQuery();                               // resets the data read out counter. The next read out data is the first available
    public boolean hasMoreData();                               // returns true if there is data left, that was not read since startDataQuery()
    public String getTagName();                                 // Returns the name for the tag of the result file, the data should appear in 
    public String getData();                                    // Returns the gathered data, e.g. typed in text or the selected item of a comboBox
    public String getTimeStamp();                               // Returns the timeStamp of the last modification by the user
    public void getNextData();                                  // prepares the next data set (if available) to be read out
}
