package scone.usertesttool;


import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * Class TaskPanel
 *
 * is used to create an empty Screen that can be filled with test items.
 *
 * I don't like to add methods to a "JPanel" that are not consistent with the
 * is-a view on Panels (e.g. addText..)
 * <p>Description: Used to display a Swing-Panel with evaluator-specific components.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Hartmut Obendorf, http://asi-www.informatik.uni-hamburg.de/personen/obendorf/
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.1, 04/23/2004
 */

public class TaskPanel extends JPanel {
    public TaskPanel() {
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        add(Box.createRigidArea(new Dimension(0,20)));

    }

    public void addText(String text) {
        Box             hbox = Box.createHorizontalBox();
//        Box             spaceBox = Box.createVerticalBox();
        JLabel          label = new JLabel(text);

        label.setFont(UIStyle.PLAINFONT);
        label.setForeground(java.awt.Color.black);
        hbox.add(Box.createRigidArea(new Dimension(20,0)));
        hbox.add(label);
        hbox.add(Box.createRigidArea(new Dimension(20,0)));
        hbox.add(Box.createHorizontalGlue());

//        spaceBox.add(hbox);
//        spaceBox.add(Box.createRigidArea(new Dimension(0,10)));

        add(hbox);
    }

    public void addText(String text, Font font) {
        Box             hbox = Box.createHorizontalBox();
//        Box             spaceBox = Box.createVerticalBox();
        JLabel          label = new JLabel(text);

        label.setFont(font);
        label.setForeground(Color.black);
        hbox.add(Box.createRigidArea(new Dimension(20,0)));
        hbox.add(label);
        hbox.add(Box.createRigidArea(new Dimension(20,0)));
        hbox.add(Box.createHorizontalGlue());

//        spaceBox.add(hbox);
//        spaceBox.add(Box.createRigidArea(new Dimension(0,10)));

        add(hbox);
    }

    public void addHtml(String text, int frameWidth) {
        Box             hbox = Box.createHorizontalBox();

        hbox.add(Box.createRigidArea(new Dimension(20,0)));

        JLabel htmlLabel = new JLabel();
        htmlLabel.setFont(UIStyle.PLAINFONT);
        htmlLabel.setForeground(Color.black);
        htmlLabel.setText("<html>"+text+"</html>");

        hbox.add(htmlLabel);
        hbox.add(Box.createRigidArea(new Dimension(20,0)));
        hbox.add(Box.createHorizontalGlue());

        add(hbox);
    }

    public void addItem(java.awt.Component component) {
        Box             hbox = Box.createHorizontalBox();
//        Box             spaceBox = Box.createVerticalBox();
        
        hbox.add(Box.createRigidArea(new Dimension(20,0)));
        hbox.add(component);
        hbox.add(Box.createRigidArea(new Dimension(20,0)));
        hbox.add(Box.createHorizontalGlue());

//        spaceBox.add(hbox);
//        spaceBox.add(Box.createRigidArea(new Dimension(0,10)));

        add(hbox);
    }

    public void addPadding(int padding) {
        Box             paddingBox = Box.createHorizontalBox();
        
        paddingBox.add(Box.createRigidArea(new Dimension(0,padding)));
        paddingBox.add(Box.createHorizontalGlue());

        add(paddingBox);
    }

    public void addItems(java.awt.Component component1, java.awt.Component component2) {
        Box             hbox = Box.createHorizontalBox();
//        Box             spaceBox = Box.createVerticalBox();

        hbox.add(component1);
        hbox.add(Box.createRigidArea(new java.awt.Dimension(20, 0)));
        hbox.add(component2);
        hbox.add(Box.createHorizontalGlue());

//        spaceBox.add(hbox);
//        spaceBox.add(Box.createRigidArea(new Dimension(0,20)));

        add(hbox);
    }
}
