package scone.usertesttool;

/*
 * @(#)DomEcho02.java	1.9 98/11/10
 *
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */


import java.util.ResourceBundle;
import java.util.Locale;

// Basic GUI components
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.ImageIcon;

/**
 * TaskWindow opens a new Swing window to display the tasks next to the browser
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Torsten Hass
 * @version 1.1, 04/21/2004
 */
public class TaskWindow extends JFrame
{
    private Container contentPane;
    private String title;
    private UserTestControl utc;

    protected static ResourceBundle labels = UserTestTool.labels;

    public TaskWindow(UserTestControl utc)
    {
        ImageIcon img = new ImageIcon("resources/scone/scone64.gif");
        setIconImage(img.getImage());  // Set icon of program
        title  = labels.getString("taskwindow");
        final UserTestControl _utc = utc;
        this.utc = utc;
        setTitle(title);
        setSize(Toolkit.getDefaultToolkit().getScreenSize().width / 2,
                Toolkit.getDefaultToolkit().getScreenSize().height - 32);
        this.setLocation(0,0);
//        this.toFront();
        addWindowListener( new WindowAdapter() {
            public void windowClosing(WindowEvent e) { 
                _utc.cancelTest();
            }
        });  
        setVisible(false);
    } // constructor



    public void displayTask(TaskPanel panel) {
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalGlue());
        box.add(panel);
        box.add(Box.createVerticalGlue());
        
        contentPane = getContentPane();
        contentPane.removeAll();
        
        contentPane.setLayout(new javax.swing.BoxLayout(contentPane, javax.swing.BoxLayout.Y_AXIS));
        contentPane.add(Box.createHorizontalGlue());
        contentPane.add(box);
        contentPane.add(Box.createHorizontalGlue());
        contentPane.validate();
//        setSize(Toolkit.getDefaultToolkit().getScreenSize().width / 2,
//                Toolkit.getDefaultToolkit().getScreenSize().height - 28);
        super.toFront();        
    }


    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }
    
    public void setTitle(String title) {
        super.setTitle(title);
    }
    
}
