/*
 * Scone - The Web Enhancement Framework
 * Copyright (c) 2004 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.usertesttool;


import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;



/**
 * UTButton is a button for scone's user test tool. This button is involked by
 * the test description xml file. In that xml file the button can be defined
 * as highlighted, enabled, disabled. The button holds a list of actions, that
 * is read by the UserTestControl when a click on the button occures.
 * The Button is enabled by default. 
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Torsten Hass
 * @version 1.0, 11/19/2003
 */

public class UTButton extends Box implements ButtonComponent, AllComponents {

    private UTButton thisInstance = this;    

    private Long            timestamp;          // stores the time, the user clicked the Button
    private String          compName = "";      // Name of this component, defined in test description xml file
    private int             bottomPadding = 10; // amount of vertical pixel added below the component
    private ArrayList       actionList = null;  // stores the list of actions, defined in the test description xml file
    
    private JButton         button;
    private Box             paddingBox;
    
    public UTButton (UserTestControl utc) {
        super(BoxLayout.Y_AXIS);

        final UserTestControl _utc = utc;
        actionList = new ArrayList();
        
        timestamp = new Long(-1);

        button = new JButton();
        button.setEnabled(true);
        button.setFont(UIStyle.PLAINFONT);
        button.setFocusPainted(true);
        button.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent actionEvent) {
                final UserTestControl utc;
                timestamp = new Long(System.currentTimeMillis());
                _utc.buttonClick(thisInstance);
            }
        }
        );
        add(button);
        paddingBox = new Box(BoxLayout.X_AXIS);
        paddingBox.add(Box.createRigidArea(new Dimension(0, bottomPadding)));
        add(paddingBox);

    }

    /**
     * This method adds a pair of Strings to the actionList
     */
    public void addAction(String command, String parameter) {
        actionList.add(new Action(command, parameter));
    }

    /**
     * setName sets the name of the button. This name is defined in the
     * xml file as an attribute of the button tag. This name is used to
     * destinct multiple buttons and to access them.
     *
     * @param name The name for the button
     */
/*    public void setName(String buttonName) {
        this.buttonName = buttonName;
    }
    
    public String getName() {
        return buttonName;
    }
*/    
    public void setText (String text) {
        button.setText(text);
    }
     
    
    public String getData() {
        return timestamp.toString();
    }

    public ArrayList getActionList () {
        return actionList;
    }
    

    public void setComponentName(String componentName) {
        compName = componentName;
    }
    
    public void setComponentBottomPadding (int padding) {
        bottomPadding = padding;
        removeAll();
        paddingBox = new Box(BoxLayout.X_AXIS);
        paddingBox.add(Box.createRigidArea(new Dimension(0, bottomPadding)));
        
        add(button);
        add(paddingBox);
    }

    public String getComponentName() {
        return compName;
    }
    
    // Implement AllComponents interface
    
    public void setComponentEnabled(boolean enable) {
        button.setEnabled(enable);       
        if (enable) {
            button.requestFocus();
        } else {
            setComponentHighlighted(false);
        }
    }

    public void setComponentHighlighted(boolean enable) {
        if (enable) {
            button.setBackground(new Color(230, 230, 128));
        } else {
            button.setBackground(new Color(204, 204, 204));
        }
    }

    public void componentRequestFocus() {
        button.requestFocus();
    }
    

}
