/*
 * Scone - The Web Enhancement Framework
 * Copyright (c) 2004 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.usertesttool;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;


/**
 * @author Torsten Hass
 * @version 1.0, 08/27/2003
 */

public class UTLikertScale extends Box implements InputComponent, AllComponents {

    private String          compName = "";      // Name of this component, defined in test description xml file
    private int             bottomPadding = 10; // amount of vertical pixel added below the component
    private int             numberOfRatings = 5;
    private String          leftLabel = "";
    private String          rightLabel = "";
    private String          description="";
    private boolean         inputRequired = false;
    private long            timeStamp = 0; 
    private JRadioButton[]  buttons;
    private JLabel          descriptionLabel = null;
    
    private Box descriptionBox;
    private Box scaleBox;
    private Box paddingBox;

    // read out control
    int readOutCounter = 0;
    int numberOfData = 1;
    
    public UTLikertScale ()  {
        super(BoxLayout.Y_AXIS);
        descriptionLabel = new JLabel();
        createLikertScale();
    }
    
    
    /**
     * Display the Likert Scale
     */
    public void createLikertScale () {
        removeAll();        // clear Box in case of previous call of createLikertScale()
        buttons = new JRadioButton[numberOfRatings];

        descriptionBox = Box.createHorizontalBox();
        descriptionLabel = new JLabel(description);
        descriptionLabel.setFont(UIStyle.PLAINFONT);
        descriptionLabel.setForeground(Color.black);
        descriptionBox.add(descriptionLabel);
        descriptionBox.add(Box.createHorizontalGlue());
        add(descriptionBox);
        
        JLabel      jlabel;
        ButtonGroup group = new ButtonGroup();
        scaleBox = Box.createHorizontalBox();

        jlabel = new JLabel(leftLabel);
        jlabel.setFont(UIStyle.PLAINFONT);
        jlabel.setForeground(Color.black);
        jlabel.setPreferredSize(new Dimension(120, 20));
        scaleBox.add(jlabel);

        scaleBox.add(Box.createRigidArea(new Dimension(10, 0)));
        for (int i = 0; i < buttons.length; i++) {
            buttons[i] = new JRadioButton(Integer.toString(i + 1));
            buttons[i].setFont(UIStyle.PLAINFONT);
            buttons[i].addActionListener(new MyActionListener());
            group.add(buttons[i]);
            scaleBox.add(buttons[i]);
//            hBox.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        scaleBox.add(Box.createRigidArea(new Dimension(10, 0)));

        jlabel = new JLabel(rightLabel);
        jlabel.setFont(UIStyle.PLAINFONT);
        jlabel.setForeground(Color.black);
//        jlabel.setPreferredSize(new Dimension(120, 20));
        scaleBox.add(jlabel);
        scaleBox.add(Box.createHorizontalGlue());
        
        add(scaleBox);
        
        paddingBox = new Box(BoxLayout.X_AXIS);
        paddingBox.add(Box.createRigidArea(new Dimension(0, bottomPadding)));
        add(paddingBox);

    }

    
    public void setDescription(String description) {
        this.description = description;
        descriptionLabel.setText(description);
    }
    
    public void setLeftLabel(String leftLabel) {
        this.leftLabel = leftLabel;
    }
    
    public void setRightLabel(String rightLabel) {
        this.rightLabel = rightLabel;
    }
    
    public void setNumberOfRatings(int numberOfRatings) {
        this.numberOfRatings = numberOfRatings;
    }
    
    // Implemetation of the InputComponent interface
/*    public void setName(String name) {
        this.name = name;
    }
    
    public String getName() {
        return name;
    }
*/    
    public void setComponentEnabled(boolean enabled) {
        for (int i = 0; i < buttons.length; i++) {
            buttons[i].setEnabled(enabled);
        }
        if (!enabled){
            setComponentHighlighted(false);
        }
    }

    public void setComponentHighlighted(boolean highlight) {
        if (highlight) {
            this.setBackground(new Color(230, 230, 128));
        } else {
            this.setBackground(new Color(204, 204, 204));
        }
    }


    public void componentRequestFocus() {
        buttons[0].requestFocus();
    }

    public void setInputRequired (boolean inputRequired) {
        this.inputRequired = inputRequired;
    }
    
    /**
     * This method, called by UserTestControl, tests if the user selected one
     * of the radio buttons. If inputRequired = true and no radio button was
     * was selected, false is returned.
     */
    public boolean changedByUser () {
        boolean foundSelectedButton = false;
        if (inputRequired) {
            for (int i = 0; i < buttons.length; i++) {
                if (buttons[i].isSelected()) {
                    foundSelectedButton = true;
                }
            }
            if (!foundSelectedButton) {
                buttons[0].requestFocus();
            }
        }
        else {
            foundSelectedButton = true;    // if inputRequired == false, changedByUser should return true
        }
        
        return foundSelectedButton;
    }

    public void setComponentName(String componentName) {
        compName = componentName;
    }
    
    public void setComponentBottomPadding (int padding) {
        bottomPadding = padding;
        removeAll();
        paddingBox = new Box(BoxLayout.X_AXIS);
        paddingBox.add(Box.createRigidArea(new Dimension(0, bottomPadding)));
        
        add(descriptionBox);
        add(scaleBox);
        add(paddingBox);
    }

    public String getComponentName() {
        return compName;
    }
    
    // Data read out implementation

    /**
     * resets the data read out counter. The next read out data is the first available
     */
    public void startDataQuery() {
        readOutCounter = 0;
    }
    
    /**
     * returns true if there is data left, that was not read since startDataQuery()
     */
    public boolean hasMoreData() {
        return readOutCounter < numberOfData;
    }
    
    /**
     * Returns the name for the tag of the result file, the data should appear in 
     */
    public String getTagName() {
        return "likertScaleSelection";
    }
    
    /**
     * Returns the gathered data, e.g. typed in text or the selected item of a comboBox
     */
    public String getData() {
        String result = "";

        for (int i = 0; i < buttons.length; i++) {
            if (buttons[i].isSelected()) {
                result = buttons[i].getText();
            }
        }
        return result;
    }

    /**
     * Returns the timeStamp of the last modification by the user
     */
    public String getTimeStamp() {
        return Long.toString(timeStamp);
    }
    
    /**
     * prepares the next data set (if available) to be read out
     */
    public void getNextData() {
        if (readOutCounter < numberOfData) {
            readOutCounter++;
        }
    }
    
    class MyActionListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            timeStamp = System.currentTimeMillis();
        }
    }

    

}
