/*
 * Scone - The Web Enhancement Framework
 * Copyright (c) 2004 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.usertesttool;


import java.awt.Color;
import java.awt.Dimension;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.JScrollPane;


/**
 * UTTextField is a text field for scone's user test tool. 
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Torsten Hass
 * @version 1.2, 04/23/2004
 *
 */
/* History
 * 
 */

public class UTTextField extends Box implements InputComponent, AllComponents {

    private String      compName = "";      // Name of this component, defined in test description xml file
    private JLabel      jLabel = null;
    private String      description = "";
    private String      textFieldText="";   // holds the text of the text field, set by the test description xml file
    private long        timeStamp = 0;
    
    private int         bottomPadding = 10; // amount of vertical pixel added below the component
    private int         height = 20;        // Height of Textfield in pixel
    
    private JTextArea   jTextArea;
    private JScrollPane scrollPane;
    private UserTestControl utc;
    private UTTextField thisInstance;
    private Box         paddingBox;
    private Box         hbox;

    private boolean     inputRequired = false;
    private boolean     componentEnable = true;
    
    // read out control
    int readOutCounter = 0;
    int numberOfData = 1;
    
/*    public UTTextField(UserTestControl utc) {
        this(utc, "", 1300); 
    }

    public UTTextField(UserTestControl utc, String description) {
        this(utc, description, 1300); 
    }

    public UTTextField(UserTestControl utc, String description, int width) {
        this(utc, description, width, true); 
    }
*/
    /**
     * Constructor with standard Size
     */
    public UTTextField(UserTestControl utc) {
        super(BoxLayout.Y_AXIS);
        
        this.utc = utc;
        thisInstance = this;
        
        jLabel = new JLabel(description + "           ");

        jLabel.setFont(UIStyle.PLAINFONT);
        jLabel.setForeground(Color.black);
        hbox = Box.createHorizontalBox();
        
        hbox.add(jLabel);
        hbox.add(Box.createHorizontalGlue());
        add(hbox);

        jTextArea = new JTextArea();

        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
//        jTextArea.setPreferredSize(new Dimension(width, 50));
//        jTextArea.setMaximumSize(new Dimension(width, 50));
        jTextArea.setEnabled(componentEnable);
//        jTextArea.addActionListener(new UTTextFieldListener());
        jTextArea.getDocument().addDocumentListener(new MyDocumentListener());

        scrollPane = new JScrollPane(jTextArea,
                                      JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                                      JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        scrollPane.setPreferredSize(new Dimension(1300, height));
        scrollPane.setMaximumSize(new Dimension(1300, height));


        setComponentEnabled(componentEnable);  
        add(scrollPane); //add(jTextArea);
        paddingBox = new Box(BoxLayout.X_AXIS);
        paddingBox.add(Box.createRigidArea(new Dimension(0, bottomPadding)));
        add(paddingBox);
    }

    public void setDescription(String description) {
        this.description = description;
        jLabel.setText(description);
    }
    
    public void setText(String text) {
        jTextArea.setText(text);
        textFieldText = text;
    }
    
    public void setHeight(int height) {
        this.height = height;
        removeAll();
        scrollPane = new JScrollPane(jTextArea,
                                      JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                                      JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        scrollPane.setPreferredSize(new Dimension(1300, height));
        scrollPane.setMaximumSize(new Dimension(1300, height));
        
        add(hbox);
        add(scrollPane);
        add(paddingBox);
    }
    

    // Implementation of InputComponent interface
    
    /**
     * setName sets the name of the component. This name is defined in the
     * xml file as an attribute of the textField tag. This name is used to
     * destinct multiple text fields
     *
     * @param name The name for the text field
     */
/*    public void setName(String name) {
        this.name = name;
    }
    
    public String getName() {
        return name;
    }
*/    
    public void setComponentEnabled(boolean enable) {
        componentEnable = enable;
        setEnabled(enable);
        jTextArea.setEnabled(enable);
        jLabel.setEnabled(enable);
        if (enable) {
            jTextArea.requestFocus();
            jTextArea.setBackground(new Color(255, 255, 255));     // white
        } else {   
            setComponentHighlighted(false);
            jTextArea.setBackground(new Color(204, 204, 204));     // gray
        }
    }  

    public void setComponentHighlighted(boolean highlight) {
        if (componentEnable) {                                      // Component can only be highlighted if it is enabled
            if (highlight) {
                jTextArea.setBackground(new Color(230, 230, 128));     // yellow
            } else {
                jTextArea.setBackground(new Color(255, 255, 255));     // white
            }
        }
    }

    public void componentRequestFocus() {
        jTextArea.requestFocus();
    }

    public void setInputRequired (boolean inputRequired) {
        this.inputRequired = inputRequired;
    }
    
    /**
     * This method, called by UserTestControl, tests if the displayed text of
     * the text field was changed by the user. If inputRequired = true and the 
     * text was not changed by the user, then false is returned.
     */
    public boolean changedByUser () {
        if (inputRequired && (jTextArea.getText().equals(textFieldText))) {
            jTextArea.requestFocus();
            return false;
        }
        return true;
    }
    
    public void setComponentName(String componentName) {
        compName = componentName;
    }
    
    public void setComponentBottomPadding (int padding) {
        bottomPadding = padding;
        removeAll();
        paddingBox = new Box(BoxLayout.X_AXIS);
        paddingBox.add(Box.createRigidArea(new Dimension(0, bottomPadding)));
        
        add(hbox);
        add(scrollPane);
        add(paddingBox);
    }

    public String getComponentName() {
        return compName;
    }
    
// Data read out implementation

    /**
     * resets the data read out counter. The next read out data is the first available
     */
    public void startDataQuery() {
        readOutCounter = 0;
    }
    
    /**
     * returns true if there is data left, that was not read since startDataQuery()
     */
    public boolean hasMoreData() {
        return readOutCounter < numberOfData;
    }
    
    /**
     * Returns the name for the tag of the result file, the data should appear in 
     */
    public String getTagName() {
        return "textFieldText";
    }
    
    /**
     * Returns the gathered data, e.g. typed in text or the selected item of a comboBox
     */
    public String getData() {
        return jTextArea.getText();
    }

    /**
     * Returns the timeStamp of the last modification by the user
     */
    public String getTimeStamp() {
        return Long.toString(timeStamp);
    }
    
    /**
     * prepares the next data set (if available) to be read out
     */
    public void getNextData() {
        if (readOutCounter < numberOfData) {
            readOutCounter++;
        }
    }
    

    class MyDocumentListener implements DocumentListener {
        
        public void insertUpdate(DocumentEvent e) {
            timeStamp = System.currentTimeMillis();
        }
        public void removeUpdate(DocumentEvent e) {
            timeStamp = System.currentTimeMillis();
        }
        public void changedUpdate(DocumentEvent e) {
            timeStamp = System.currentTimeMillis();
        }
    }    
        

}
