/*
 * Scone - The Web Enhancement Framework
 * Copyright (c) 2004 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.usertesttool;

import java.util.ResourceBundle;
import java.util.Locale;

import scone.util.ErrorLog;
import scone.util.PersistentProperties;


/**
 * UserTestTool calls all neccessary Objects 
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Torsten Hass, Harald Weinreich
 * @version 1.5, 04/21/2004
 */
public class UserTestTool extends scone.Plugin {
    private boolean descriptionOnWindow = true;
    protected static PersistentProperties props = new PersistentProperties("config/properties/scone.usertesttool.UserTestTool.xml");
    protected static ResourceBundle labels;

    static {
        if (props.get("Language") == "German")
            labels = ResourceBundle.getBundle("config/properties/UserTestToolLabels",Locale.GERMAN);
        else
            labels = ResourceBundle.getBundle("config/properties/UserTestToolLabels",Locale.ENGLISH);
    }

    private UserTestControl utc = null;
    
    // requirements!
    public int getRequirements() {
        return CONSIDERLINKS | ACCESSTRACKING;       // Use CONSIDERLINKS if you want to get events if a user clicks on a link.
    }

    /**
     * Initialize UserTestTool
     */
    public void init() {
        try {


            UserTestToolMeg userTestToolMeg = new UserTestToolMeg(this);
            userTestToolMeg.setup("userTestToolMeg", "host~usertest.scone.de", 100);
            addMeg(userTestToolMeg);
            

            // Start UserTestControl thread
            utc = new UserTestControl();
            utc.start();
            
            // Start EventObserver
            EventObserver eo = new EventObserver();
            eo.setUtc(utc);  // Let EventObserver inform UserTestControl about new AccessEvents
            
            // Let UserTestToolMeg access UserTestControl to inform it in case of Events
            UserTestToolMeg.setUtc(utc);


      } catch (Exception e) {
         ErrorLog.log(this, "init()", "Could not enable UserTestTool!", e);
      }
   }
   
   
    public UserTestControl getUtc () {
        return utc;
    }

}
