/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package scone.util;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * An simple Swing-Alertbox for Scone
 * <p>Description: Is used to display a text in a dialog box until the user presses OK.</p>
 * <p>Copyright: Copyright (C) 2003</p>
 * <p>Company: University of Hamburg, Germany</p>
 * @author Harald Weinreich, http://vsis-www.informatik.uni-hamburg.de/~weinreic/
 * @version 1.1
 */
public class AlertBox extends JDialog implements ActionListener {
    public final static int LEFT = 0;
    public final static int CENTER = 1;
    public final static String SPACE = "  ";
    private JButton okButton;
    private JPanel textPanel, buttonPanel;

    /**
     * The Rows of the Alertbox are defined by giving an String-Array as parameter.
     * z.B. AlertBox a = new AlertBox("Titel", new String[] {"Zeile 1","Zweite Zeile"})
     * @param f JFrame the calling JFrame
     */
    public AlertBox(JFrame f, String[] message) {
        this(f, "Attention!", true, message);
    }

    // Aufruf mit Titel und Array
    public AlertBox(JFrame f, String title, boolean modal, String[] message) {
        this(f, title, modal, message, CENTER);
    }

    // Aufruf mit allen Parametern
    public AlertBox(JFrame f, String title, boolean modal, String[] message, int alignment) {
        super(f, title, modal);
        Container cp = getContentPane();

        cp.setLayout(new BorderLayout());
        cp.setBackground(Color.lightGray);
        // Einen Panel fr den Text
        textPanel = new JPanel();
        textPanel.setLayout(new GridLayout(0, 1));
        int alignmentValue = alignment == LEFT ? JLabel.LEFT : JLabel.CENTER;

        for (int i = 0; i < message.length; i++) {
            // Die Textzeilen als "Label"s erzeugen. Font setzen.
            // System.out.println(message[i]);  // Debugging
            JLabel l = new JLabel(SPACE + message[i] + SPACE, alignmentValue);

            l.setFont(new Font("Serif", Font.BOLD, 13));
            textPanel.add(l);
        }
        // Der Button
        okButton = new JButton("  OK  ");
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        // Ein Panel fr den Button, da er zentriert werden soll.
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(okButton);
        // Die Panels hinzufgen
        cp.add("Center", textPanel);
        cp.add("South", buttonPanel);
        this.pack();
        this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - 100);
        this.setVisible(true);
    }

    // Wenn der OK-Button gedrckt wird, dann soll die Alert-Box geschlossen werden.
    public void actionPerformed(ActionEvent e) {
        // System.out.println(e.getActionCommand());  // Debugging
        if ("OK".equals(e.getActionCommand())) {
            // System.out.println("Taste gedrueckt!");  // Debugging
            setVisible(false);                  // Dialog entfernen
            dispose();          // Methode von "Window", um Ressourcen freizugeben...
        }
    }
}

