// The original implementation in Java is described at http://www.javaworld.com/javaworld/javatips/jw-javatip66.html
// Some parts taken from futils by Alexander Maryanovsky at MIT, see http://www.hightemplar.com/jin/downloads/futils/
package scone.util;


import java.io.IOException;
import java.io.InterruptedIOException;


/**
 * A simple, static class to display a URL in the system browser.
 * Under Unix, the system browser is hard-coded to be 'netscape'. 
 * Netscape must be in your PATH for this to work. This has been 
 * tested with the following platforms: AIX, HP-UX and Solaris.
 * Under Windows, this will bring up the default browser under windows, 
 * usually either Netscape or Microsoft IE. The default browser is 
 * determined by the OS. This has been tested under Windows 95/98/NT/2000/XP.
 * 
 * Examples:
 * BrowserControl.displayURL("http://www.javaworld.com") 
 * BrowserControl.displayURL("file://c:\\docs\\index.html") 
 * BrowserContorl.displayURL("file:///user/joe/index.html"); 
 * 
 * Note - you must include the url type -- either "http://" or 
 * "file://". 
 */ 

public class BrowserControl { 

    /**
     * Display a file in the system browser. If you want to display a 
     * file, you must include the absolute path name. 
     * 
     * @param url the file's url (the url must start with either "http://" or 
     * "file://"). 
     */ 

    public static void displayURL(String url) throws IOException { 
        if (isWindows()) { 
            if (url.endsWith(".html") || url.endsWith(".htm")) {
                int lastChar = url.charAt(url.length() - 1);

                url = url.substring(0, url.length() - 1) + "%"
                        + Integer.toHexString(lastChar);
            }
            String cmd = "rundll32 url.dll,FileProtocolHandler " + url;
            Process p = Runtime.getRuntime().exec(cmd); 
        } else if (isMacOS()) {
            String[] commandLine = {"netscape", url}; 
            Process process = Runtime.getRuntime().exec(commandLine); 
        } else { 
            // Too many unix platforms to check, so we'll just assume it *is* unix.
            // Under Unix, Netscape has to be running for the "-remote" 
            // command to work. So, we try sending the command and 
            // check for an exit value. If the return value is 0, 
            // it worked, otherwise we need to start the browser. 

            // cmd = 'netscape -remote openURL(http://www.javaworld.com)' 
            String cmd = "netscape -remote openURL(" + url + ")"; 
            Process p = Runtime.getRuntime().exec(cmd); 

            try { 
                // wait for exit code -- if it's 0, command worked, 
                // otherwise we need to start the browser up. 
                int exitCode = p.waitFor(); 

                if (exitCode != 0) { 
                    // Command failed, start up the browser 
      
                    // cmd = 'netscape http://www.javaworld.com' 
                    cmd = "netscape " + url; 
                    p = Runtime.getRuntime().exec(cmd); 
                } 
            } catch (InterruptedException x) { 
                System.err.println("Error bringing up browser, cmd='" + cmd + "'"); 
                System.err.println("Caught: " + x); 
                throw new InterruptedIOException(x.getMessage());
            }
        } 
    } 

    /**
     * Clear the history of the Windows Internet Explorer
     */ 
    public static void ClearIEHistory() throws IOException { 
        if (isWindows()) { 
            String cmd = "resources\\scone\\ClearIEHistory.exe";
            Process p = Runtime.getRuntime().exec(cmd); 
        } 
    }
   
    /**
     * Clear the cache of the Windows Internet Explorer
     */ 
    public static void ClearIECache() throws IOException { 
        if (isWindows()) { 
            String cmd = "resources\\scone\\ClearIECache.exe";
            Process p = Runtime.getRuntime().exec(cmd); 
        } 
    }
   
    /**
     * Start the Windows Internet Explorer
     */ 
    public static void StartIE(String url) throws IOException { 
        if (isWindows()) { 
            String cmd = "resources\\scone\\StartIE.exe " + url;
            Process p = Runtime.getRuntime().exec(cmd); 
        } 
    }

    /**
     * Brings up the default mailer with the given address in the "to:" field.
     */

    public static void displayMailer(String address) throws IOException {
        displayURL("mailto:" + address);
    }

    /**
     * Try to determine whether this application is running under Windows 
     * or some other platform by examing the "os.name" property. 
     * 
     * @return true if this application is running under a Windows OS 
     */ 

    public static boolean isWindows() { 
        String os = System.getProperty("os.name"); 

        if ((os != null) && os.startsWith("Windows")) {
            return true;
        } else { 
            return false;
        } 
    } 

    /**
     * Try to determine whether this application is running under MacOS 
     * or some other platform by examing the "os.name" property. 
     * 
     * @return true if this application is running under a MacOS 
     */ 

    public static boolean isMacOS() { 
        String os = System.getProperty("os.name"); 

        if ((os != null) && os.startsWith("Mac")) {
            return true;
        } else { 
            return false;
        } 
    } 

}
