package scone.util;


import java.util.Vector;

import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;

import com.google.soap.search.GoogleSearch;
import com.google.soap.search.GoogleSearchFault;
import com.google.soap.search.GoogleSearchResult;
import com.google.soap.search.GoogleSearchResultElement;


/**
 * represents the Google search engine.
 * <br> This class can be used to easily query Google using the Google SOAP-API.
 */

public class Google {

    // the Google key
    String key;
	
    /**
     * create sa new Google representation.
     * @param key the Google key
     */
    public Google(String key) {
        this.key = key;
    }

    // merges the Google result with the Scone database.
    // returns a vector of HtmlNode objects
    Vector getInfo(GoogleSearchResultElement[] results) {
        Vector nodes = new Vector();
        NetNode node = null;
        HtmlNode hNode = null;
        String s = null;
		
        for (int i = 0; i < results.length; i++) {
			
            try {
                // get the corresponding HtmlNode for each result url from the db
                    // System.out.println(i + "  " +results[i].getURL());
                node = NetNodeCache.get(results[i].getURL());
                hNode = HtmlNodeCache.check(node);
                if (hNode == null) {
                    // create a new node and fill it with as many information as we have
                    hNode = HtmlNodeCache.get(node);
                    hNode.setBodyText(results[i].getSnippet());
                    hNode.setTitle(results[i].getTitle());
                }
				
                // add the node to the result-vector    
                nodes.add(hNode);
				
            } catch (Exception ex) {
                ex.printStackTrace();
            }
			
        }
        return nodes;
    }

    /**
     * returns pages that link to the specified url.
     * <br> The pages will be returned as HtmlNode objects stored in a Vector
     * @param url the URL
     * @param max limits the number of resulting pages
     * @return a Vector of HtmlNode
     */
    public Vector getBackLinks(String url, int max) throws Exception {
        GoogleSearch search = new GoogleSearch();

        search.setKey(key);
        search.setQueryString("link:" + url);	
        search.setMaxResults(max);
        return getInfo(search.doSearch().getResultElements());
    }
	
    /**
     * returns pages that are related to the specified url.
     * <br> The pages will be returned as HtmlNode objects stored in a Vector
     * @param url the URL
     * @param max limits the number of resulting pages
     * @return a Vector of HtmlNode
     */
    public Vector getRelated(String url, int max){
        GoogleSearch search = new GoogleSearch();
        try {
            search.setKey(key);
            search.setQueryString("related:" + url);		
            search.setMaxResults(max);
            // System.out.print("\nsend query: related:"+url);
            GoogleSearchResult results = search.doSearch();
            // System.out.println(results.toString());
            // System.out.print("get results ");
            GoogleSearchResultElement[] resultElements=results.getResultElements();
            // System.out.print("parse results ");
            return getInfo(resultElements);
        } catch (GoogleSearchFault f) {
            System.out.println("scone.util.Google: Call to the Google Web APIs failed:");
            System.out.println(f.toString());
            ErrorLog.log(this,"scone.util.Google.getRelated()", "Call to Web API failed", f);
        }
        return null;
    }
	
}

