/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package  scone.util;


import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 * represents the children of a specified XML node which have the specified name
 */
public class NodeEnumeration {
    protected NodeList list = null;
    protected int pos = -1;
    protected String name = null;
    protected Node nextNode = null;

    /**
     * creates a NodeEnumeration
     * @param parentNode the parent Node
     * @param childName the name of the children
     */
    public NodeEnumeration(Node parentNode, String childName) {
        this.list = parentNode.getChildNodes();
        this.name = childName;
        this.pos = 0;
        this.nextNode = null;
    }

    /**
     * returns true if nextNode() will return another child node
     * @return true if nextNode() will return another child node
     */
    public boolean hasMoreNodes() {
        if (nextNode != null) {
            return  true;
        }
        nextNode = findNext();
        if (nextNode != null) {
            return  true;
        } else {
            return  false;
        }
    }

    /**
     * returns the next child node
     * @return the next child node or null if there is none
     */
    protected Node findNext() {
        for (; pos < list.getLength(); pos++) {
            if (list.item(pos).getNodeName().equals(name)) {
                pos++;
                return  list.item(pos - 1);
            }
        }
        return  null;
    }

    /**
     * returns the next child node
     * @return the next child node or null if there is none
     */
    public Node nextNode() {
        Node n = null;

        if (hasMoreNodes()) {
            n = nextNode;
            nextNode = null;
            return  n;
        } else {
            return  null;
        }
    }
}

