/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package  scone.util;


import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;


/**
 * PersistentPropertiesGUI creates a GUI for Scone Plugins and 
 * for Database and Accesstracking features.
 * See PersistentProperties for features.
 */
public class PersistentPropertiesGui extends JDialog {
    PersistentProperties properties = null;
    PluginRepository plugins = null;

    /**
     * Create a new Persistentproperties GUI
     * @param parent a parent Dialog Frame
     * @param properties the PersistentProperties to be visualized
     */
    public PersistentPropertiesGui(Dialog parent, PersistentProperties properties) {
        super(parent, "Edit Properties", true);
        this.properties = properties;
        createGui();
        this.pack();
        this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    /**
     * Create a new Persistentproperties GUI
     * @param parent a parent Frame
     * @param properties the PersistentProperties to be visualized
     */
    public PersistentPropertiesGui(Frame parent, PersistentProperties properties) {
        super(parent, "Edit Properties", true);
        this.properties = properties;
        createGui();
        this.pack();
        this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    /**
     * Create the GUI for the properties of the selected plugin
     */
    public void createGui() {
        // count rows to display
        int rows = 1;

        if (properties.getKeys() == null) {
            System.out.println("shit! " + properties.getName());
        }
        for (Enumeration e = properties.getKeys(); e.hasMoreElements();) {
            if (properties.getType((String) e.nextElement()) != null) {
                rows++;
            }
        }

        Container cp = getContentPane();

        cp.setLayout(new GridLayout(rows, 2, 6, 4));
        String name = null;
        String type = null;

        // go through the enumeration of properties
        // for each property, add an appropriate GUI to the dialog
        for (Enumeration e = properties.getKeys(); e.hasMoreElements();) {
            name = (String) e.nextElement();
            type = properties.getType(name);
            if (type != null) {
                cp.add(new Label(name.replace('_', ' '), Label.RIGHT));
                if (type.equals("boolean")) {
                    cp.add(new PPGCheckbox(properties, name));
                }
                if (type.equals("choice")) {
                    cp.add(new PPGChoice(properties, name));
                }
                if (type.equals("text")) {
                    cp.add(new PPGTextField(properties, name));
                }
            }
        }
        // if no properties where found, we at least have to generate a message
        if (rows == 1) {
            cp.add(new Label("No parameters to configure."));
        }
        
        // add cancel and save button
        ImageIcon cancelIcon = new ImageIcon("resources/scone/cancel.gif");
        JButton cancel = new JButton("      Cancel     ", cancelIcon);

        cp.add(cancel);
        cancel.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                try {
                    dispose();
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        );
        if (rows > 1) {
            ImageIcon exitIcon = new ImageIcon("resources/scone/exit.gif");
            JButton done = new JButton("      Save       ", exitIcon);

            cp.add(done);
            done.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e) {
                    try {
                        properties.store();
                        dispose();
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            );
        }
    }
}


/**
 * the visualization of a boolean property
 */
class PPGCheckbox extends JCheckBox {
    PersistentProperties props = null;
    String name = null;

    /**
     * creates a new PPGCheckbox
     * @props the list of the properties
     * @param name the name of the property in the list
     */
    PPGCheckbox(final PersistentProperties props, final String name) {
        super();
        this.props = props;
        this.name = name;
        setSelected(props.get(name).equals("true"));
        addItemListener(new ItemListener() {

            public void itemStateChanged(ItemEvent e) {
                try {
                    if (isSelected()) {
                        props.set(name, "true");
                    } else {
                        props.set(name, "false");
                    }
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        );
    }
}


/**
 * the visualization of a choice property
 */
class PPGChoice extends JComboBox {             
    PersistentProperties props = null;
    String name = null;
    Vector values = null;

    /**
     * creates a new PPGChoice 
     * @props the list of the properties
     * @param name the name of the property in the list
     */
    PPGChoice(final PersistentProperties props, final String name) {
        super();
        this.props = props;
        this.name = name;
        this.values = props.getValues(name);
        String value = props.get(name);
        String cvalue = null;

        for (int i = 0; i < values.size(); i++) {
            cvalue = (String) values.elementAt(i);
            addItem(cvalue);   
            if (cvalue.equals(value)) {
                setSelectedIndex(i);
            }
        }
        addItemListener(new ItemListener() {

            public void itemStateChanged(ItemEvent e) {
                try {
                    props.set(name, getSelectedItem().toString());              
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        );
    }
}


/**
 * the visualization of a text property
 */
class PPGTextField extends JTextField {
    PersistentProperties props = null;
    String name = null;

    /**
     * creates a new PPGTextField 
     * @props the list of the properties
     * @param name the name of the property in the list
     */
    PPGTextField(final PersistentProperties props, final String name) {
        super();
        this.props = props;
        this.name = name;
        setText(props.get(name));
        javax.swing.text.Document doc = getDocument();

        doc.addDocumentListener(new DocumentListener() {

            public void changedUpdate(DocumentEvent e) {
                try {
                    props.set(name, getText());
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void insertUpdate(DocumentEvent e) {
                changedUpdate(e);
            }

            public void removeUpdate(DocumentEvent e) {
                changedUpdate(e);
            }
        }
        );
    }
}

