/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package  scone.util;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JFrame;

import scone.Scone;


/**
 * This Frame is able to shutdown or abort WBI (and thus Scone)
 */
public class WbiKillerGUI extends JFrame {

    /**
     * creates a new WbiKillerGUI
     */
    public WbiKillerGUI() {
        super("WBI Killer");
        createGui();
        addWindowListener(new SconeConfigWindowAdapter(this));
    }

    /**
     * sets up the GUI
     */
    private void createGui() {
        Container cp = getContentPane();

        // cp.setLayout(new BorderLayout());
        cp.setBackground(Color.lightGray);

        JButton sd = new JButton("shutdown");

        getContentPane().add(sd, BorderLayout.NORTH);
        sd.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Scone.shutdownWBI(100);
            }
        }
        );

        JButton ab = new JButton("abort");

        getContentPane().add(ab, BorderLayout.SOUTH);
        ab.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Scone.abortWBI();
            }
        }
        );
        // Show thing...
        this.setLocation(300, 200);
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    /**
     *  This WindowAdapter helps to close the config window...
     */
    class SconeConfigWindowAdapter extends WindowAdapter {
        protected WbiKillerGUI configFrame;

        // Der Konstruktor
        public SconeConfigWindowAdapter(WbiKillerGUI configFrame) {
            this.configFrame = configFrame;
        }

        // Das Fenster soll geschlossen werden
        public void windowClosing(WindowEvent e) {
            configFrame.dispose();
        }

        // Das Fenster wurde geschlossen
        public void windowClosed(WindowEvent e) {}
    }

}

