/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package  scone.util;


import java.io.FileReader;
import java.io.Reader;

import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;


/**
 * an XML helper class.
 * This class provides easy parsing of XML documents 
 * and simple access methods for DOMs.
 */
public class XMLHelper {

    /**
     * test method
     */
    public static void main(String[] args) throws Exception {
        Document dom = parseReader(new FileReader("test.xml"));

        printNodeStructure(dom, "");
    }

    /**
     * parses a Reader into a DOM.
     * @param reader a reader containing an XML document
     * @return a DOM of the XML document
     * @exception Exception
     */
    public static Document parseReader(Reader reader) throws Exception {
        DOMParser parser = new DOMParser();

        parser.parse(new InputSource(reader));
        return  parser.getDocument();
    }

    /**
     * prints a simple structure of a Node and its children.
     * Nice for debugging.
     * @param node a Node
     * @param indent set this to an empty String!
     */
    public static void printNodeStructure(Node node, String indent) {
        // is there anything to do?
        if (node == null) {
            return;
        }
        indent += "   ";
        System.out.println(indent + node);
        NodeList children = node.getChildNodes();

        for (int iChild = 0; iChild < children.getLength(); iChild++) {
            printNodeStructure(children.item(iChild), indent);
        }
    }

    /**
     * returns the first attribute of node with the specified name, or null otherwise
     * @param name the name of the attribute
     * @param node the node
     * @return the attribute as a node
     */
    public static Node getAttribute(String name, Node node) {
        NamedNodeMap attributes = node.getAttributes();

        if (attributes == null) {
            return  null;
        }
        for (int i = 0; i < attributes.getLength(); i++) {
            if (attributes.item(i).getNodeName().equals(name)) {
                return  attributes.item(i);
            }
        }
        return  null;
    }

    /**
     * returns the first child node of node with the specified name, or null otherwise
     * @param name the name of the child
     * @param node the node
     * @return the child
     */
    public static Node getChild(String name, Node node) {
        NodeList children = node.getChildNodes();

        if (children == null) {
            return  null;
        }
        for (int i = 0; i < children.getLength(); i++) {
            if (children.item(i).getNodeName().equals(name)) {
                return  children.item(i);
            }
        }
        return  null;
    }
}

