/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 // Titel:        Scone
// Version:
// Copyright:    Copyright (c) 1999
// Autor:       Dietgar Voelzke
// Firma:      University of Hamburg
// Beschreibung:  Das Programm liest aus einem Logfile
// Daten ein, formatiert diese und schreibt
// die Daten dann in eine SQL Datenbank.

package scone.util.logreader;


import java.util.Hashtable;


public class SconeDB {

    // This is the filename of the string to read!
    public static String filename = new String("log/ergonomie_2000.log");

    public static void main(String[] args) {

        SconeReader sr = new SconeReader(filename);  // Read from file
        SconeWriter sw = new SconeWriter();  // Writer to database: SQL-Connection

        Hashtable dataContainer = new Hashtable();

        // read first line
        sr.readLineIntoContainer(dataContainer);

        while (!sr.isEof()) {
            // wite Data
            sw.writeElements(dataContainer);
            // Read next line
            sr.readLineIntoContainer(dataContainer);
        }
        System.out.println("All lines read!");

        System.out.println("Closing InputStream");
        sr.close();
        System.out.println("Writing buffers");
        sw.close();
        System.out.println("bye bye...");
        System.exit(0);
    }
}

/*
 DataContainer

 private
 host
 date ...

 public :
 getHost
 setHost (String s) {
 host = new String(s);
 Kopie???
 }
 getDate
 setDate
 */