/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.util.logreader;


import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;


public class SconeDateFormat {

    public static void main(String[] args) {

        Date currentTime_1 = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss z", Locale.US);
        String dateString = formatter.format(currentTime_1);

        System.out.println("Now:\n" + dateString);

        // Parse the previous string back into a Date.
        Date currentTime_2 = convert(dateString);

        System.out.println(currentTime_2.toString());

        String s = "02/Jun/2000:05:19:22 +0200";

        System.out.println("\n" + s);
        s = addGMT(s);
        System.out.println(s);

        // Parse the previous string back into a Date.
        Date currentTime_3 = convert(s);

        System.out.println(currentTime_3);
    }

    public static String addGMT(String date) {
        int plusZeichen = date.lastIndexOf("+");

        return date.substring(0, plusZeichen - 1) + " GMT"
                + date.substring(plusZeichen, plusZeichen + 3) + ":"
                + date.substring(plusZeichen + 3);
    }

    public static Date convert(String date) { 
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss z", Locale.US);
        ParsePosition pos = new ParsePosition(0);

        return formatter.parse(date, pos);
    }

}

