/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.util.logreader;


import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;


public class SconeReader {
  
    public static char[] aufbau = {'h', 'i', 'a', 'd', 'm', 'u', 'p', 's', 'b', 'f'}; // der Aufbau der Zeile eines Logfiles kann hier festgelegt werden.
    public static String baseUrl = "http://vsys-www.informatik.uni-hamburg.de";

    // bedeutet
    // h - HOST: The fully-qualified domain name of the client, or its IP number if the name ist not available.
    // i - IDENT: IF IdentityCheck is enabled and the client machine runs identd, then this is the identity information reportet by the client.
    // a - AUTHUSER: If the request was for an password protected document, then this is the userid used in the request.
    // d - DATE:
    // m - METHOD: GET, POST, PUT etc.
    // r - REQUEST: The request line from the client, enclosed in double quotes (").
    // u - URL: The requested URL 
    // p - PROTOCOL: HTTP 1.0, 1.1 etc.
    // s - STATUS: The three digit status code returned to the client.
    // b - BYTES:  The number of bytes in the object returned to the client, not including any headers.
    // f - REFERRER: Where did the user come from?
    // Trash: Keine Ahnung wofr.

    protected BufferedReader in;
	
    private boolean eof = false;
    private int lineNumber = 0;
    private static boolean sconeDebug = true;

    // Create dataContainer for with tokens of line
    protected void readLineIntoContainer(Hashtable datacontainer) {

        lineNumber++;
        System.out.println("-> Parsing line " + lineNumber);
        String line = null;

        try {	
            line = in.readLine();
            if (line == null || line.length() == 0) {
                this.eof = true;
                return;
            }
        } catch (IOException ioe) {
            System.err.println(ioe);
        }

        if (sconeDebug) {
            System.out.println(line);
        }

        // Copy token into array
        StringTokenizer st = new StringTokenizer(line, " ");
        String token[] = new String[30];

        for (int i = 0; st.hasMoreElements(); i++) {
            token[i] = st.nextToken();
        }

        // copy token into hashtable
        for (int i = 0, j = 0; i < (aufbau.length); i++) {
            switch ((aufbau[i])) {
            case 'h': 
                datacontainer.put("host", token[j]);
                if (sconeDebug) {
                    System.out.println("host: " + token[j]);
                }
                j++;
                break;

            case 'i':
                datacontainer.put("ident", token[j]);
                if (sconeDebug) {
                    System.out.println("ident: " + token[j]);
                }
                j++;
                break;

            case 'a':
                datacontainer.put("authuser", token[j]);
                if (sconeDebug) {
                    System.out.println("authuser: " + token[j]);
                }
                j++;
                break;

            case 'd': 
                String date = (new StringBuffer(token[j])).append(" ").append((token[(j + 1)])).toString();

                date = date.substring(1, date.length() - 1);
                datacontainer.put("date", date);
                if (sconeDebug) {
                    System.out.println("date: " + date);
                }
                j += 2;  // Two tokens collected...
                break;

            case 'm':
                datacontainer.put("method", token[j].substring(1));
                if (sconeDebug) {
                    System.out.println("method: " + token[j].substring(1));
                }
                j++;
                break;

            case 'u':
                String url = token[j];

                if (!url.startsWith("http:")) {
                    url = baseUrl + url;
                }
                datacontainer.put("uri", url);
                if (sconeDebug) {
                    System.out.println("uri: " + url);
                }
                j++;
                break;

            case 'p':
                datacontainer.put("protocol", token[j].substring(0, token[j].length() - 1));
                if (sconeDebug) {
                    System.out.println("protocol: " + token[j].substring(0, token[j].length() - 1));
                }
                j++;
                break;

            case 'r': 
                String request = (new StringBuffer(token[j])).append(" ").append((token[(j + 1)])).append(" ").append((token[(j + 2)])).toString();

                datacontainer.put("request", request);
                if (sconeDebug) {
                    System.out.println("request: " + request);
                }
                j += 3; // Three tokens used...
                break;

            case 's':
                datacontainer.put("status", token[j]);
                if (sconeDebug) {
                    System.out.println("status: " + token[j]);
                }
                j++;
                break;

            case 'b':
                datacontainer.put("bytes", token[j]);
                if (sconeDebug) {
                    System.out.println("bytes: " + token[j]);
                }
                j++;
                break;

            case 'f':
                datacontainer.put("referrer", token[j].substring(1, token[j].length() - 1));
                if (sconeDebug) {
                    System.out.println("referrer: " + token[j].substring(1, token[j].length() - 1));
                }
                j++;
                break;

            default:
                if (sconeDebug) {
                    System.out.println("Unknown Parameter!");
                }
            }
        }
    }

    void tokenToAufbauElementsKonverter(String line) {}
	
    // Constructor
    public SconeReader(String filename) {
        try {
            in = new BufferedReader(new FileReader(filename));
        } catch (IOException ioe) {
            System.err.println(ioe);
        }
    }

    // CLose stream
    public void close() {
        try {
            this.in.close();
        }  // Always close a stream when you are done with it
        catch (IOException ioe) {
            System.err.println(ioe);
        }
    }

    // is eof??
    public boolean isEof() {
        return eof;  
    }

}

