/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.util.logreader;


import java.util.Hashtable;

import scone.netobjects.Access;
import scone.netobjects.AccessCache;
import scone.netobjects.CacheTable;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import scone.netobjects.User;
import scone.netobjects.UserCache;


public class SconeWriter {

    // Create a new SconeWriter
    public SconeWriter() {
        // init DBTableAdapter
        DBTableAdapter.init();
	   
        NetNodeCache.init(2 * 60 * 1000, CacheTable.LAZYGC);
        AccessCache.init(5 * 60 * 1000, CacheTable.LAZYGC);
        UserCache.init(10 * 60 * 1000, CacheTable.LAZYGC);   		
    }

    // Close DB Connection
    protected void close() { 
        NetNodeCache.clean();
        UserCache.clean();      
        AccessCache.clean();
    }

    protected void writeElements(Hashtable dataContainer) {
        String nodeNodeId = "0";
        String referrerNodeId = "0";
        String userId = "0";
		
        // Create Node URI id
        NetNode node = NetNodeCache.get((String) dataContainer.get("uri"));

        node.setSize((String) dataContainer.get("bytes"));
        node.access();
        nodeNodeId = node.getNodeId();
        // System.out.println("node: "+nodeNodeId);

        // Create referrer node id
        if (((String) dataContainer.get("referrer")).startsWith("http://")) {
            NetNode referrer = NetNodeCache.get((String) dataContainer.get("referrer"));

            referrer.access();
            referrerNodeId = referrer.getNodeId();
            // System.out.println("referrer: "+referrerNodeId);
        }
        // else System.out.println("Illegal Referrer");

        // Create new user object node IP Address...
        String userName = ((String) dataContainer.get("host"));

        if (userName.length() > 16) {
            userName = userName.substring(userName.length() - 16);
        }  // hchsten 16 Zeichen...
        User user = UserCache.get(userName);  

        // System.out.println("UserName: "+user.getUserName());
        userId = user.getUserId();
        // System.out.println("UserId: "+userId);
	   
        String timeString = ((String) dataContainer.get("date"));
        java.util.Date time = SconeDateFormat.convert(timeString);

        // Save Access event...
        Access a = AccessCache.get(userId, nodeNodeId, time.getTime(), "");

        a.setReferrerNodeId(referrerNodeId);
    }
}
