/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.util.tokenstream;


import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

import com.ibm.wbi.Copyright;
import com.ibm.wbi.MegObject;
import com.ibm.wbi.NotCharDataException;
import com.ibm.wbi.RequestEvent;


/**
 * a dummy TokenOutputStream. Writes Tokens to nowhere.
 * 
 * @author Volkert Buchmann 
 * @version 1.0
 */

public class DummyTokenOutputStream extends TokenOutputStream {

    private final static String COPYRIGHT = Copyright.COPYRIGHT;

    /**
     * creates a new DummyTokenOutputStream.
     * This is an 'empty' implementation of TokenOutputStream. Its methods
     * do nothing.
     */
    public DummyTokenOutputStream() {}

    /**
     * returns null
     * @return null
     */
    public static synchronized TokenOutputStream create(RequestEvent e) throws Exception {
        return null;
    }

    /**
     * returns null
     * @return null
     */
    public InputStream getInputStream() {
        return null;
    }

    /**
     * returns null
     * @return null
     */
    public Reader getReader() 
            throws UnsupportedEncodingException, NotCharDataException {

        return null;
    }
    
    /**
     * returns null
     * @return null
     */
    public Reader getReader(String encoding) 
            throws UnsupportedEncodingException, NotCharDataException {
        return getReader();
    }
  
    /**
     * returns null
     * @return null
     */
    public MegObject getClone() {
        return null;
    }

    /**
     * does nothing
     */
    public void write(Token buf[], int offset, int length) throws IOException {}

    /**
     * does nothing
     */
    public void write(Token token) throws IOException {}

    /**
     * does nothing
     */
    public void write(Token buf[]) throws IOException {}

    /**
     * does nothing
     */
    public void close() throws IOException {}

    /**
     * returns null
     * @return null
     */
    TokenBuffer getTokenBuffer() {
        return null;
    }

    /**
     * returns null
     * @return null
     */
    protected Object getBufferContext() {
        return null;
    }
   
}
