/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.util.tokenstream;




/**
 * an HTML comment.<p> 
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann 
 */

public class HtmlCommentToken implements Token {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
   	
    /**
     * preceding whitespaces
     */
    protected String whiteSpaces;
	
    /**
     * the text
     */
    protected String text;
	
    /**
     * creates a <code>HtmlCommentToken</code>
     *
     * @param text the text
     */
    public HtmlCommentToken(String text, StringBuffer whiteSpaces) {
        this.text = text;
        this.whiteSpaces = new String(whiteSpaces);
    }
	
    /**
     * returns a clone of this token
     * @return the clone
     */
    public Token getClone() {
        return new HtmlCommentToken(text, new StringBuffer(whiteSpaces));
    }
   
    /**
     * returns the text of the comment
     * @return the text of the comment
     */
    public String getComment() {
        return text;
    }
	
    /**
     * returns a String representation of this Token.
     * @return whiteSpaces+comment as a tag
     */	
    public String toString() {
        return whiteSpaces + "<!--" + text + "-->";
    }
	
}
