/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.util.tokenstream;


import adc.parser.HtmlTag;


/**
 * an HTML script element.
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann 
 */

public class HtmlScriptToken extends HtmlTagToken {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
   	
    /**
     * the script
     */
    protected String script;
	
    /**
     * creates a <code>HtmlScriptToken</code>
     *
     * @param tag the tag
     * @param script the script
     * @param whiteSpaces preceding whitespaces
     */
    public HtmlScriptToken(HtmlTag tag, String script, StringBuffer whiteSpaces) {
        this.tag = tag;
        this.script = script;
        this.whiteSpaces = new String(whiteSpaces);
    }

    /**
     * returns a clone of this Token
     * @return the clone
     */
    public Token getClone() {
        try {
            HtmlTag nTag = new HtmlTag(tag);

            return new HtmlScriptToken(nTag, script, new StringBuffer(whiteSpaces));		
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(tag.toString());
            System.out.println(tag.getTagString());
        }
        return null;   	
    }
	
    /**
     * returns the language of the script
     * @return the language of the script
     */
    public String getLanguage() {
        return tag.getParam("language");
    }
	
    /**
     * returns the script if there is any.
     * @return the script or null if none was specified
     */
    public String getScript() {
        return script;
    }

    /**
     * returns the URI of the script if specified
     * @return the URI or null if none was specified
     */
    public String getSource() {
        return tag.getParam("src");
    }
   
    /**
     * returns a string representation of the script element, preceded by the whitespaces
     * @return the script element as a String
     */
    public String toString() {
        return super.toString() + script + "</script>";
    }
	
}
