/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.util.tokenstream;


import adc.parser.HtmlTag;


/**
 * an HTML tag.
 *
 * @author Harald Weinreich
 * @author Volkert Buchmann 
 */

public class HtmlTagToken extends HtmlTag implements Token {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
   	
    /**
     * preceding whitespaces
     */
    protected String whiteSpaces;
	
    /**
     * the tag
     */
    protected HtmlTag tag;

    protected HtmlTagToken() {
        try {
            this.tag = new HtmlTag();
            this.whiteSpaces = "";
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
		
    /**
     * creates a <code>HtmlTagToken</code>
     *
     * @param tag the tag
     * @param whiteSpaces preceding whitespaces
     */
    public HtmlTagToken(HtmlTag tag, StringBuffer whiteSpaces) {
        this.tag = tag;
        this.whiteSpaces = new String(whiteSpaces);
    }

    /**
     * creates an empty HtmlTagToken of the specified type.
     * @param tagType the type of the tag
     */
    public HtmlTagToken(String tagType) {
        try {
            this.tag = new HtmlTag();
            tag.setTag(tagType);
            this.whiteSpaces = "";
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
	
    /**
     * returns a clone of this Token
     * @return the clone
     */
    public Token getClone() {
        try {
            if (tag == null) {
                System.out.println("tag==null!");
            }
	   	   
            if (tag.getTagString() == null) {
                System.out.println("shit:");
                System.out.println(tag.getTagType());
            }
            HtmlTag nTag = new HtmlTag(tag);

            return new HtmlTagToken(nTag, new StringBuffer(whiteSpaces));
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println(tag.toString());
            System.out.println(tag.getTagString());
        }
        return null;   	
    }
	
    /**
     * returns the type of the tag.
     * see adc.parser.HtmlTag for tag type constants
     * @return	tag type, e.g. one of the <b>T_</b> constants.
     */
    public int getTagType() {
        return tag.getTagType();
    }

    /**
     * returns the tag name, for example table
     * @return	tag name, the same name as passed to the constructor.
     */
    public String getTagString() {
        return tag.getTagString();
    }

    /**
     * returns true if this tag is an end tag
     * @return	true if this is an end tag or not, i.e. if the tag has a slash before the name.
     */
    public boolean isEndTag() {
        return tag.isEndTag();
    }

    /**
     * Looks up a tag param name and returns the associated
     * value, if any. 
     *
     * @param	name  name of param, must be lowercase
     * @return	the value associated with the name, or null.
     */
    public String getParam(String name) {
        return tag.getParam(name);
    }

    /**
     * returns true if this tag has the specified parameter
     * @param name the name of the tag in lower case
     * @return true if the parameter exists
     */
    public boolean hasParam(String name) {
        return tag.hasParam(name);
    }

    /**
     * returns the vlaue of the specified parameter as an int
     * @param name the name of the parameter, must be lower case
     * @return the value of the parameter as an int (if possible)
     */
    public int getIntParam(String name) throws NumberFormatException {
        return tag.getIntParam(name);
    }

    /**
     * Associates a param name with a value.
     *
     * @param	name  name of param, must be a lowercase name
     * @param	value  value associated with name
     */
    public void setParam(String name, String value) {
        tag.setParam(name, value);
    }

    /**
     * Associates a param name with a value, preserving the original
     * name.
     *
     * @param	name  name of param, the convention is to use a lowercase name
     * @param	value  value associated with name
     * @param	originalName  preserve the orginal case of name
     */
    public void setParam(String name, String value, String originalName) {
        tag.setParam(name, value, originalName);
    }

    /**
     * Remove association of a param name with a value.
     *
     * @param	name  name of param to remove, the convention is to use a lowercase name
     */
    public void removeParam(String name) {
        tag.removeParam(name);
    }

    /**
     * returns the preceding whitespaces of the tag
     * @return the whitespaces
     */
    public String getWhiteSpaces() {
        return whiteSpaces;
    }
   
    /**
     * returns a string representation of the tag, preceded by the whitespaces
     * @return the tag as a String
     */
    public String toString() {
        return (whiteSpaces + tag.toString());
    }
	
    /**
     * returns true if the tag type is h1-4, table, a, area, img, form, or pre
     * @return whether the tag is expected to be in the body
     */
    public boolean isInBody() {
        int type = getTagType();

        return ((type == T_H1) ||    // Headings 1-5
                (type == T_H2) || (type == T_H3) || (type == T_H4)
                || (type == T_H5) || (type == T_H6) || (type == T_TABLE)
                || (type == T_A) || // Link
                (type == T_AREA) || (type == T_IMG) || // Image
                (type == T_FORM) || // Form
                (type == T_PRE)); 	   
    }
	
}
