/*
 * Scone - The Web Enhancement Framework
 * Copyright (C) 2009 Harald Weinreich, Volkert Buchmann, Frank Wollenweber, Torsten Ha
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 package scone.util.tokenstream;


import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.protocol.http.DocumentInfo;


/**
 * helper class for the use of TokenStreams.
 * This class encapsulates a WBI RequestEvent.
 */

public class SconePipe {
    protected RequestEvent e = null;
    protected TokenInputStream in = null;
    protected TokenOutputStream out = null;
    private static Object sync = new Object();

    /**
     * creates a new SconePipe from a WBI RequestEvent
     * @param e the RequestEvent
     */
    public SconePipe(RequestEvent e) throws Exception {
        this.e = e;
    }

    /**
     * returns the TokenInputStream of this SconePipe.
     * If neccessary, a new TokenInputStream is created from the MegInputStream.
     * @return the TokenInputStream
     */
    public TokenInputStream getTokenInputStream() {
        try {
            if (in == null) {

            	// we have to save the size, it is deleted in TokenInputStream.create(e)
                DocumentInfo documentInfo = (DocumentInfo) e.getRequestInfo();
                String size = documentInfo.getResponseContentLength();

                // Check if Inputstream is already created...
                if (e.getMegObjectType() == Class.forName("scone.util.tokenstream.TokenOutputStream")) {
                	while (((TokenOutputStream)e.getMegObject()).getMetaInfo()==null) {
                    	// System.out.println("YYY"+((TokenOutputStream)e.getMegObject()).getMetaInfo());
                    	// Here seem to be some timing problems with WBI we cannot explain! Just wait a little bit, and
                    	// hope the stream will be created soon after...
            			Thread.sleep(50);
                		/* try { wait(50); }
                		catch (InterruptedException e) { }
                		catch (IllegalMonitorStateException e) {
                			System.out.println("Thread error, retrying...");
                			Thread.sleep(100);
                		} */
                	}
                }

           		in = TokenInputStream.create(e);

           		if (in.getMetaInfo() == null) {
           			System.out.println("IN.getMeatInfo is null!!!!!");
                	System.out.println(e.toString());
                    System.out.println(e.getMegObjectType());
                	System.out.println(documentInfo);
                }

               	// ensure that the baseNode is specified
               	if (in.getMetaInfo().get("baseNode") == null) {
               		scone.netobjects.NetNode baseNode = scone.netobjects.NetNodeCache.get(documentInfo);

               		baseNode.setSize(size);
               		baseNode.access();
               		in.getMetaInfo().put("baseNode", baseNode);
               	}
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return in;
	}


    /**
     * returns the TokenOutputStream
     * @return the TokenOutputStream
     */
    public TokenOutputStream getTokenOutputStream() {
    	try {
            if (out == null) {
                if (in == null) {
                    return null;
                }
            	synchronized (sync) {
            		out = TokenOutputStream.create(e);
            		out.setMetaInfo(in.getMetaInfo());
            	}
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return out;
    }

    /**
     * returns the RequestEvent
     * @return the RequestEvent
     */
    public RequestEvent getRequestEvent() {
        return e;
    }

    /**
     * closes the tokenstreams
     */
    public void close() throws Exception {
        in.close();
        out.close();
    }
}
